% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpclattice_operations.R
\name{vpclattice_create_service_network_vpc_association}
\alias{vpclattice_create_service_network_vpc_association}
\title{Associates a VPC with a service network}
\usage{
vpclattice_create_service_network_vpc_association(
  clientToken = NULL,
  securityGroupIds = NULL,
  serviceNetworkIdentifier,
  tags = NULL,
  vpcIdentifier
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you retry a request that completed
successfully using the same client token and parameters, the retry
succeeds without performing any actions. If the parameters aren't
identical, the retry fails.}

\item{securityGroupIds}{The IDs of the security groups. Security groups aren't added by default.
You can add a security group to apply network level controls to control
which resources in a VPC are allowed to access the service network and
its services. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html}{Control traffic to resources using security groups}
in the \emph{Amazon VPC User Guide}.}

\item{serviceNetworkIdentifier}{[required] The ID or Amazon Resource Name (ARN) of the service network. You must
use the ARN when the resources specified in the operation are in
different accounts.}

\item{tags}{The tags for the association.}

\item{vpcIdentifier}{[required] The ID of the VPC.}
}
\description{
Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the resources within that VPC to be clients and communicate with other services in the service network. For more information, see \href{https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations}{Manage VPC associations} in the \emph{Amazon VPC Lattice User Guide}.

See \url{https://www.paws-r-sdk.com/docs/vpclattice_create_service_network_vpc_association/} for full documentation.
}
\keyword{internal}
