% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_update_firewall_rule_group_association}
\alias{route53resolver_update_firewall_rule_group_association}
\title{Changes the association of a FirewallRuleGroup with a VPC}
\usage{
route53resolver_update_firewall_rule_group_association(
  FirewallRuleGroupAssociationId,
  Priority = NULL,
  MutationProtection = NULL,
  Name = NULL
)
}
\arguments{
\item{FirewallRuleGroupAssociationId}{[required] The identifier of the FirewallRuleGroupAssociation.}

\item{Priority}{The setting that determines the processing order of the rule group among
the rule groups that you associate with the specified VPC. DNS Firewall
filters VPC traffic starting from the rule group with the lowest numeric
priority setting.

You must specify a unique priority for each rule group that you
associate with a single VPC. To make it easier to insert rule groups
later, leave space between the numbers, for example, use 100, 200, and
so on. You can change the priority setting for a rule group association
after you create it.}

\item{MutationProtection}{If enabled, this setting disallows modification or removal of the
association, to help prevent against accidentally altering DNS firewall
protections.}

\item{Name}{The name of the rule group association.}
}
\description{
Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.

See \url{https://paws-r.github.io/docs/route53resolver/update_firewall_rule_group_association.html} for full documentation.
}
\keyword{internal}
