% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_test_function}
\alias{cloudfront_test_function}
\title{Tests a CloudFront function}
\usage{
cloudfront_test_function(Name, IfMatch, Stage = NULL, EventObject)
}
\arguments{
\item{Name}{[required] The name of the function that you are testing.}

\item{IfMatch}{[required] The current version (\code{ETag} value) of the function that you are testing,
which you can get using
\code{\link[=cloudfront_describe_function]{describe_function}}.}

\item{Stage}{The stage of the function that you are testing, either \code{DEVELOPMENT} or
\code{LIVE}.}

\item{EventObject}{[required] The event object to test the function with. For more information about
the structure of the event object, see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function}{Testing functions}
in the \emph{Amazon CloudFront Developer Guide}.}
}
\description{
Tests a CloudFront function.

See \url{https://paws-r.github.io/docs/cloudfront/test_function.html} for full documentation.
}
\keyword{internal}
