% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_virtual_gateway}
\alias{appmesh_delete_virtual_gateway}
\title{Deletes an existing virtual gateway}
\usage{
appmesh_delete_virtual_gateway(meshName, meshOwner = NULL, virtualGatewayName)
}
\arguments{
\item{meshName}{[required] The name of the service mesh to delete the virtual gateway from.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then it's the ID of the account that shared
the mesh with your account. For more information about mesh sharing, see
\href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualGatewayName}{[required] The name of the virtual gateway to delete.}
}
\description{
Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.

See \url{https://paws-r.github.io/docs/appmesh/delete_virtual_gateway.html} for full documentation.
}
\keyword{internal}
