# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include directconnect_service.R
NULL

#' Accepts a proposal request to attach a virtual private gateway or
#' transit gateway to a Direct Connect gateway
#'
#' Accepts a proposal request to attach a virtual private gateway or
#' transit gateway to a Direct Connect gateway.
#'
#' @usage
#' directconnect_accept_direct_connect_gateway_association_proposal(
#'   directConnectGatewayId, proposalId, associatedGatewayOwnerAccount,
#'   overrideAllowedPrefixesToDirectConnectGateway)
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#' @param proposalId &#91;required&#93; The ID of the request proposal.
#' @param associatedGatewayOwnerAccount &#91;required&#93; The ID of the AWS account that owns the virtual private gateway or
#' transit gateway.
#' @param overrideAllowedPrefixesToDirectConnectGateway Overrides the Amazon VPC prefixes advertised to the Direct Connect
#' gateway.
#' 
#' For information about how to set the prefixes, see [Allowed
#' Prefixes](https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
#' in the *AWS Direct Connect User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$accept_direct_connect_gateway_association_proposal(
#'   directConnectGatewayId = "string",
#'   proposalId = "string",
#'   associatedGatewayOwnerAccount = "string",
#'   overrideAllowedPrefixesToDirectConnectGateway = list(
#'     list(
#'       cidr = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_accept_direct_connect_gateway_association_proposal
directconnect_accept_direct_connect_gateway_association_proposal <- function(directConnectGatewayId, proposalId, associatedGatewayOwnerAccount, overrideAllowedPrefixesToDirectConnectGateway = NULL) {
  op <- new_operation(
    name = "AcceptDirectConnectGatewayAssociationProposal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$accept_direct_connect_gateway_association_proposal_input(directConnectGatewayId = directConnectGatewayId, proposalId = proposalId, associatedGatewayOwnerAccount = associatedGatewayOwnerAccount, overrideAllowedPrefixesToDirectConnectGateway = overrideAllowedPrefixesToDirectConnectGateway)
  output <- .directconnect$accept_direct_connect_gateway_association_proposal_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$accept_direct_connect_gateway_association_proposal <- directconnect_accept_direct_connect_gateway_association_proposal

#' Deprecated
#'
#' Deprecated. Use AllocateHostedConnection instead.
#' 
#' Creates a hosted connection on an interconnect.
#' 
#' Allocates a VLAN number and a specified amount of bandwidth for use by a
#' hosted connection on the specified interconnect.
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_allocate_connection_on_interconnect(bandwidth,
#'   connectionName, ownerAccount, interconnectId, vlan)
#'
#' @param bandwidth &#91;required&#93; The bandwidth of the connection. The possible values are 50Mbps,
#' 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and
#' 10Gbps. Note that only those AWS Direct Connect Partners who have met
#' specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or
#' 10Gbps hosted connection.
#' @param connectionName &#91;required&#93; The name of the provisioned connection.
#' @param ownerAccount &#91;required&#93; The ID of the AWS account of the customer for whom the connection will
#' be provisioned.
#' @param interconnectId &#91;required&#93; The ID of the interconnect on which the connection will be provisioned.
#' @param vlan &#91;required&#93; The dedicated VLAN provisioned to the connection.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_connection_on_interconnect(
#'   bandwidth = "string",
#'   connectionName = "string",
#'   ownerAccount = "string",
#'   interconnectId = "string",
#'   vlan = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_connection_on_interconnect
directconnect_allocate_connection_on_interconnect <- function(bandwidth, connectionName, ownerAccount, interconnectId, vlan) {
  op <- new_operation(
    name = "AllocateConnectionOnInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_connection_on_interconnect_input(bandwidth = bandwidth, connectionName = connectionName, ownerAccount = ownerAccount, interconnectId = interconnectId, vlan = vlan)
  output <- .directconnect$allocate_connection_on_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_connection_on_interconnect <- directconnect_allocate_connection_on_interconnect

#' Creates a hosted connection on the specified interconnect or a link
#' aggregation group (LAG) of interconnects
#'
#' Creates a hosted connection on the specified interconnect or a link
#' aggregation group (LAG) of interconnects.
#' 
#' Allocates a VLAN number and a specified amount of capacity (bandwidth)
#' for use by a hosted connection on the specified interconnect or LAG of
#' interconnects. AWS polices the hosted connection for the specified
#' capacity and the AWS Direct Connect Partner must also police the hosted
#' connection for the specified capacity.
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_allocate_hosted_connection(connectionId, ownerAccount,
#'   bandwidth, connectionName, vlan, tags)
#'
#' @param connectionId &#91;required&#93; The ID of the interconnect or LAG.
#' @param ownerAccount &#91;required&#93; The ID of the AWS account ID of the customer for the connection.
#' @param bandwidth &#91;required&#93; The bandwidth of the connection. The possible values are 50Mbps,
#' 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and
#' 10Gbps. Note that only those AWS Direct Connect Partners who have met
#' specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or
#' 10Gbps hosted connection.
#' @param connectionName &#91;required&#93; The name of the hosted connection.
#' @param vlan &#91;required&#93; The dedicated VLAN provisioned to the hosted connection.
#' @param tags The tags associated with the connection.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_hosted_connection(
#'   connectionId = "string",
#'   ownerAccount = "string",
#'   bandwidth = "string",
#'   connectionName = "string",
#'   vlan = 123,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_hosted_connection
directconnect_allocate_hosted_connection <- function(connectionId, ownerAccount, bandwidth, connectionName, vlan, tags = NULL) {
  op <- new_operation(
    name = "AllocateHostedConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_hosted_connection_input(connectionId = connectionId, ownerAccount = ownerAccount, bandwidth = bandwidth, connectionName = connectionName, vlan = vlan, tags = tags)
  output <- .directconnect$allocate_hosted_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_hosted_connection <- directconnect_allocate_hosted_connection

#' Provisions a private virtual interface to be owned by the specified AWS
#' account
#'
#' Provisions a private virtual interface to be owned by the specified AWS
#' account.
#' 
#' Virtual interfaces created using this action must be confirmed by the
#' owner using ConfirmPrivateVirtualInterface. Until then, the virtual
#' interface is in the `Confirming` state and is not available to handle
#' traffic.
#'
#' @usage
#' directconnect_allocate_private_virtual_interface(connectionId,
#'   ownerAccount, newPrivateVirtualInterfaceAllocation)
#'
#' @param connectionId &#91;required&#93; The ID of the connection on which the private virtual interface is
#' provisioned.
#' @param ownerAccount &#91;required&#93; The ID of the AWS account that owns the virtual private interface.
#' @param newPrivateVirtualInterfaceAllocation &#91;required&#93; Information about the private virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_private_virtual_interface(
#'   connectionId = "string",
#'   ownerAccount = "string",
#'   newPrivateVirtualInterfaceAllocation = list(
#'     virtualInterfaceName = "string",
#'     vlan = 123,
#'     asn = 123,
#'     mtu = 123,
#'     authKey = "string",
#'     amazonAddress = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     customerAddress = "string",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_private_virtual_interface
directconnect_allocate_private_virtual_interface <- function(connectionId, ownerAccount, newPrivateVirtualInterfaceAllocation) {
  op <- new_operation(
    name = "AllocatePrivateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_private_virtual_interface_input(connectionId = connectionId, ownerAccount = ownerAccount, newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation)
  output <- .directconnect$allocate_private_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_private_virtual_interface <- directconnect_allocate_private_virtual_interface

#' Provisions a public virtual interface to be owned by the specified AWS
#' account
#'
#' Provisions a public virtual interface to be owned by the specified AWS
#' account.
#' 
#' The owner of a connection calls this function to provision a public
#' virtual interface to be owned by the specified AWS account.
#' 
#' Virtual interfaces created using this function must be confirmed by the
#' owner using ConfirmPublicVirtualInterface. Until this step has been
#' completed, the virtual interface is in the `confirming` state and is not
#' available to handle traffic.
#' 
#' When creating an IPv6 public virtual interface, omit the Amazon address
#' and customer address. IPv6 addresses are automatically assigned from the
#' Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
#'
#' @usage
#' directconnect_allocate_public_virtual_interface(connectionId,
#'   ownerAccount, newPublicVirtualInterfaceAllocation)
#'
#' @param connectionId &#91;required&#93; The ID of the connection on which the public virtual interface is
#' provisioned.
#' @param ownerAccount &#91;required&#93; The ID of the AWS account that owns the public virtual interface.
#' @param newPublicVirtualInterfaceAllocation &#91;required&#93; Information about the public virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_public_virtual_interface(
#'   connectionId = "string",
#'   ownerAccount = "string",
#'   newPublicVirtualInterfaceAllocation = list(
#'     virtualInterfaceName = "string",
#'     vlan = 123,
#'     asn = 123,
#'     authKey = "string",
#'     amazonAddress = "string",
#'     customerAddress = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     routeFilterPrefixes = list(
#'       list(
#'         cidr = "string"
#'       )
#'     ),
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_public_virtual_interface
directconnect_allocate_public_virtual_interface <- function(connectionId, ownerAccount, newPublicVirtualInterfaceAllocation) {
  op <- new_operation(
    name = "AllocatePublicVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_public_virtual_interface_input(connectionId = connectionId, ownerAccount = ownerAccount, newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation)
  output <- .directconnect$allocate_public_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_public_virtual_interface <- directconnect_allocate_public_virtual_interface

#' Provisions a transit virtual interface to be owned by the specified AWS
#' account
#'
#' Provisions a transit virtual interface to be owned by the specified AWS
#' account. Use this type of interface to connect a transit gateway to your
#' Direct Connect gateway.
#' 
#' The owner of a connection provisions a transit virtual interface to be
#' owned by the specified AWS account.
#' 
#' After you create a transit virtual interface, it must be confirmed by
#' the owner using ConfirmTransitVirtualInterface. Until this step has been
#' completed, the transit virtual interface is in the `requested` state and
#' is not available to handle traffic.
#'
#' @usage
#' directconnect_allocate_transit_virtual_interface(connectionId,
#'   ownerAccount, newTransitVirtualInterfaceAllocation)
#'
#' @param connectionId &#91;required&#93; The ID of the connection on which the transit virtual interface is
#' provisioned.
#' @param ownerAccount &#91;required&#93; The ID of the AWS account that owns the transit virtual interface.
#' @param newTransitVirtualInterfaceAllocation &#91;required&#93; Information about the transit virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_transit_virtual_interface(
#'   connectionId = "string",
#'   ownerAccount = "string",
#'   newTransitVirtualInterfaceAllocation = list(
#'     virtualInterfaceName = "string",
#'     vlan = 123,
#'     asn = 123,
#'     mtu = 123,
#'     authKey = "string",
#'     amazonAddress = "string",
#'     customerAddress = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_transit_virtual_interface
directconnect_allocate_transit_virtual_interface <- function(connectionId, ownerAccount, newTransitVirtualInterfaceAllocation) {
  op <- new_operation(
    name = "AllocateTransitVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_transit_virtual_interface_input(connectionId = connectionId, ownerAccount = ownerAccount, newTransitVirtualInterfaceAllocation = newTransitVirtualInterfaceAllocation)
  output <- .directconnect$allocate_transit_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_transit_virtual_interface <- directconnect_allocate_transit_virtual_interface

#' Associates an existing connection with a link aggregation group (LAG)
#'
#' Associates an existing connection with a link aggregation group (LAG).
#' The connection is interrupted and re-established as a member of the LAG
#' (connectivity to AWS is interrupted). The connection must be hosted on
#' the same AWS Direct Connect endpoint as the LAG, and its bandwidth must
#' match the bandwidth for the LAG. You can re-associate a connection
#' that\'s currently associated with a different LAG; however, if removing
#' the connection would cause the original LAG to fall below its setting
#' for minimum number of operational connections, the request fails.
#' 
#' Any virtual interfaces that are directly associated with the connection
#' are automatically re-associated with the LAG. If the connection was
#' originally associated with a different LAG, the virtual interfaces
#' remain associated with the original LAG.
#' 
#' For interconnects, any hosted connections are automatically
#' re-associated with the LAG. If the interconnect was originally
#' associated with a different LAG, the hosted connections remain
#' associated with the original LAG.
#'
#' @usage
#' directconnect_associate_connection_with_lag(connectionId, lagId)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param lagId &#91;required&#93; The ID of the LAG with which to associate the connection.
#'
#' @section Request syntax:
#' ```
#' svc$associate_connection_with_lag(
#'   connectionId = "string",
#'   lagId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_connection_with_lag
directconnect_associate_connection_with_lag <- function(connectionId, lagId) {
  op <- new_operation(
    name = "AssociateConnectionWithLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_connection_with_lag_input(connectionId = connectionId, lagId = lagId)
  output <- .directconnect$associate_connection_with_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_connection_with_lag <- directconnect_associate_connection_with_lag

#' Associates a hosted connection and its virtual interfaces with a link
#' aggregation group (LAG) or interconnect
#'
#' Associates a hosted connection and its virtual interfaces with a link
#' aggregation group (LAG) or interconnect. If the target interconnect or
#' LAG has an existing hosted connection with a conflicting VLAN number or
#' IP address, the operation fails. This action temporarily interrupts the
#' hosted connection\'s connectivity to AWS as it is being migrated.
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_associate_hosted_connection(connectionId,
#'   parentConnectionId)
#'
#' @param connectionId &#91;required&#93; The ID of the hosted connection.
#' @param parentConnectionId &#91;required&#93; The ID of the interconnect or the LAG.
#'
#' @section Request syntax:
#' ```
#' svc$associate_hosted_connection(
#'   connectionId = "string",
#'   parentConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_hosted_connection
directconnect_associate_hosted_connection <- function(connectionId, parentConnectionId) {
  op <- new_operation(
    name = "AssociateHostedConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_hosted_connection_input(connectionId = connectionId, parentConnectionId = parentConnectionId)
  output <- .directconnect$associate_hosted_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_hosted_connection <- directconnect_associate_hosted_connection

#' Associates a virtual interface with a specified link aggregation group
#' (LAG) or connection
#'
#' Associates a virtual interface with a specified link aggregation group
#' (LAG) or connection. Connectivity to AWS is temporarily interrupted as
#' the virtual interface is being migrated. If the target connection or LAG
#' has an associated virtual interface with a conflicting VLAN number or a
#' conflicting IP address, the operation fails.
#' 
#' Virtual interfaces associated with a hosted connection cannot be
#' associated with a LAG; hosted connections must be migrated along with
#' their virtual interfaces using AssociateHostedConnection.
#' 
#' To reassociate a virtual interface to a new connection or LAG, the
#' requester must own either the virtual interface itself or the connection
#' to which the virtual interface is currently associated. Additionally,
#' the requester must own the connection or LAG for the association.
#'
#' @usage
#' directconnect_associate_virtual_interface(virtualInterfaceId,
#'   connectionId)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param connectionId &#91;required&#93; The ID of the LAG or connection.
#'
#' @section Request syntax:
#' ```
#' svc$associate_virtual_interface(
#'   virtualInterfaceId = "string",
#'   connectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_virtual_interface
directconnect_associate_virtual_interface <- function(virtualInterfaceId, connectionId) {
  op <- new_operation(
    name = "AssociateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_virtual_interface_input(virtualInterfaceId = virtualInterfaceId, connectionId = connectionId)
  output <- .directconnect$associate_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_virtual_interface <- directconnect_associate_virtual_interface

#' Confirms the creation of the specified hosted connection on an
#' interconnect
#'
#' Confirms the creation of the specified hosted connection on an
#' interconnect.
#' 
#' Upon creation, the hosted connection is initially in the `Ordering`
#' state, and remains in this state until the owner confirms creation of
#' the hosted connection.
#'
#' @usage
#' directconnect_confirm_connection(connectionId)
#'
#' @param connectionId &#91;required&#93; The ID of the hosted connection.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_connection(
#'   connectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_connection
directconnect_confirm_connection <- function(connectionId) {
  op <- new_operation(
    name = "ConfirmConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_connection_input(connectionId = connectionId)
  output <- .directconnect$confirm_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_connection <- directconnect_confirm_connection

#' Accepts ownership of a private virtual interface created by another AWS
#' account
#'
#' Accepts ownership of a private virtual interface created by another AWS
#' account.
#' 
#' After the virtual interface owner makes this call, the virtual interface
#' is created and attached to the specified virtual private gateway or
#' Direct Connect gateway, and is made available to handle traffic.
#'
#' @usage
#' directconnect_confirm_private_virtual_interface(virtualInterfaceId,
#'   virtualGatewayId, directConnectGatewayId)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param virtualGatewayId The ID of the virtual private gateway.
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_private_virtual_interface(
#'   virtualInterfaceId = "string",
#'   virtualGatewayId = "string",
#'   directConnectGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_private_virtual_interface
directconnect_confirm_private_virtual_interface <- function(virtualInterfaceId, virtualGatewayId = NULL, directConnectGatewayId = NULL) {
  op <- new_operation(
    name = "ConfirmPrivateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_private_virtual_interface_input(virtualInterfaceId = virtualInterfaceId, virtualGatewayId = virtualGatewayId, directConnectGatewayId = directConnectGatewayId)
  output <- .directconnect$confirm_private_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_private_virtual_interface <- directconnect_confirm_private_virtual_interface

#' Accepts ownership of a public virtual interface created by another AWS
#' account
#'
#' Accepts ownership of a public virtual interface created by another AWS
#' account.
#' 
#' After the virtual interface owner makes this call, the specified virtual
#' interface is created and made available to handle traffic.
#'
#' @usage
#' directconnect_confirm_public_virtual_interface(virtualInterfaceId)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_public_virtual_interface(
#'   virtualInterfaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_public_virtual_interface
directconnect_confirm_public_virtual_interface <- function(virtualInterfaceId) {
  op <- new_operation(
    name = "ConfirmPublicVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_public_virtual_interface_input(virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$confirm_public_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_public_virtual_interface <- directconnect_confirm_public_virtual_interface

#' Accepts ownership of a transit virtual interface created by another AWS
#' account
#'
#' Accepts ownership of a transit virtual interface created by another AWS
#' account.
#' 
#' After the owner of the transit virtual interface makes this call, the
#' specified transit virtual interface is created and made available to
#' handle traffic.
#'
#' @usage
#' directconnect_confirm_transit_virtual_interface(virtualInterfaceId,
#'   directConnectGatewayId)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_transit_virtual_interface(
#'   virtualInterfaceId = "string",
#'   directConnectGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_transit_virtual_interface
directconnect_confirm_transit_virtual_interface <- function(virtualInterfaceId, directConnectGatewayId) {
  op <- new_operation(
    name = "ConfirmTransitVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_transit_virtual_interface_input(virtualInterfaceId = virtualInterfaceId, directConnectGatewayId = directConnectGatewayId)
  output <- .directconnect$confirm_transit_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_transit_virtual_interface <- directconnect_confirm_transit_virtual_interface

#' Creates a BGP peer on the specified virtual interface
#'
#' Creates a BGP peer on the specified virtual interface.
#' 
#' You must create a BGP peer for the corresponding address family
#' (IPv4/IPv6) in order to access AWS resources that also use that address
#' family.
#' 
#' If logical redundancy is not supported by the connection, interconnect,
#' or LAG, the BGP peer cannot be in the same address family as an existing
#' BGP peer on the virtual interface.
#' 
#' When creating a IPv6 BGP peer, omit the Amazon address and customer
#' address. IPv6 addresses are automatically assigned from the Amazon pool
#' of IPv6 addresses; you cannot specify custom IPv6 addresses.
#' 
#' For a public virtual interface, the Autonomous System Number (ASN) must
#' be private or already whitelisted for the virtual interface.
#'
#' @usage
#' directconnect_create_bgp_peer(virtualInterfaceId, newBGPPeer)
#'
#' @param virtualInterfaceId The ID of the virtual interface.
#' @param newBGPPeer Information about the BGP peer.
#'
#' @section Request syntax:
#' ```
#' svc$create_bgp_peer(
#'   virtualInterfaceId = "string",
#'   newBGPPeer = list(
#'     asn = 123,
#'     authKey = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     amazonAddress = "string",
#'     customerAddress = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_bgp_peer
directconnect_create_bgp_peer <- function(virtualInterfaceId = NULL, newBGPPeer = NULL) {
  op <- new_operation(
    name = "CreateBGPPeer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_bgp_peer_input(virtualInterfaceId = virtualInterfaceId, newBGPPeer = newBGPPeer)
  output <- .directconnect$create_bgp_peer_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_bgp_peer <- directconnect_create_bgp_peer

#' Creates a connection between a customer network and a specific AWS
#' Direct Connect location
#'
#' Creates a connection between a customer network and a specific AWS
#' Direct Connect location.
#' 
#' A connection links your internal network to an AWS Direct Connect
#' location over a standard Ethernet fiber-optic cable. One end of the
#' cable is connected to your router, the other to an AWS Direct Connect
#' router.
#' 
#' To find the locations for your Region, use DescribeLocations.
#' 
#' You can automatically add the new connection to a link aggregation group
#' (LAG) by specifying a LAG ID in the request. This ensures that the new
#' connection is allocated on the same AWS Direct Connect endpoint that
#' hosts the specified LAG. If there are no available ports on the
#' endpoint, the request fails and no connection is created.
#'
#' @usage
#' directconnect_create_connection(location, bandwidth, connectionName,
#'   lagId, tags, providerName)
#'
#' @param location &#91;required&#93; The location of the connection.
#' @param bandwidth &#91;required&#93; The bandwidth of the connection.
#' @param connectionName &#91;required&#93; The name of the connection.
#' @param lagId The ID of the LAG.
#' @param tags The tags to associate with the lag.
#' @param providerName The name of the service provider associated with the requested
#' connection.
#'
#' @section Request syntax:
#' ```
#' svc$create_connection(
#'   location = "string",
#'   bandwidth = "string",
#'   connectionName = "string",
#'   lagId = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   providerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_connection
directconnect_create_connection <- function(location, bandwidth, connectionName, lagId = NULL, tags = NULL, providerName = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_connection_input(location = location, bandwidth = bandwidth, connectionName = connectionName, lagId = lagId, tags = tags, providerName = providerName)
  output <- .directconnect$create_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_connection <- directconnect_create_connection

#' Creates a Direct Connect gateway, which is an intermediate object that
#' enables you to connect a set of virtual interfaces and virtual private
#' gateways
#'
#' Creates a Direct Connect gateway, which is an intermediate object that
#' enables you to connect a set of virtual interfaces and virtual private
#' gateways. A Direct Connect gateway is global and visible in any AWS
#' Region after it is created. The virtual interfaces and virtual private
#' gateways that are connected through a Direct Connect gateway can be in
#' different AWS Regions. This enables you to connect to a VPC in any
#' Region, regardless of the Region in which the virtual interfaces are
#' located, and pass traffic between them.
#'
#' @usage
#' directconnect_create_direct_connect_gateway(directConnectGatewayName,
#'   amazonSideAsn)
#'
#' @param directConnectGatewayName &#91;required&#93; The name of the Direct Connect gateway.
#' @param amazonSideAsn The autonomous system number (ASN) for Border Gateway Protocol (BGP) to
#' be configured on the Amazon side of the connection. The ASN must be in
#' the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
#' The default is 64512.
#'
#' @section Request syntax:
#' ```
#' svc$create_direct_connect_gateway(
#'   directConnectGatewayName = "string",
#'   amazonSideAsn = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_direct_connect_gateway
directconnect_create_direct_connect_gateway <- function(directConnectGatewayName, amazonSideAsn = NULL) {
  op <- new_operation(
    name = "CreateDirectConnectGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_direct_connect_gateway_input(directConnectGatewayName = directConnectGatewayName, amazonSideAsn = amazonSideAsn)
  output <- .directconnect$create_direct_connect_gateway_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_direct_connect_gateway <- directconnect_create_direct_connect_gateway

#' Creates an association between a Direct Connect gateway and a virtual
#' private gateway
#'
#' Creates an association between a Direct Connect gateway and a virtual
#' private gateway. The virtual private gateway must be attached to a VPC
#' and must not be associated with another Direct Connect gateway.
#'
#' @usage
#' directconnect_create_direct_connect_gateway_association(
#'   directConnectGatewayId, gatewayId,
#'   addAllowedPrefixesToDirectConnectGateway, virtualGatewayId)
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#' @param gatewayId The ID of the virtual private gateway or transit gateway.
#' @param addAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to advertise to the Direct Connect gateway
#' 
#' This parameter is required when you create an association to a transit
#' gateway.
#' 
#' For information about how to set the prefixes, see [Allowed
#' Prefixes](https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
#' in the *AWS Direct Connect User Guide*.
#' @param virtualGatewayId The ID of the virtual private gateway.
#'
#' @section Request syntax:
#' ```
#' svc$create_direct_connect_gateway_association(
#'   directConnectGatewayId = "string",
#'   gatewayId = "string",
#'   addAllowedPrefixesToDirectConnectGateway = list(
#'     list(
#'       cidr = "string"
#'     )
#'   ),
#'   virtualGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_direct_connect_gateway_association
directconnect_create_direct_connect_gateway_association <- function(directConnectGatewayId, gatewayId = NULL, addAllowedPrefixesToDirectConnectGateway = NULL, virtualGatewayId = NULL) {
  op <- new_operation(
    name = "CreateDirectConnectGatewayAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_direct_connect_gateway_association_input(directConnectGatewayId = directConnectGatewayId, gatewayId = gatewayId, addAllowedPrefixesToDirectConnectGateway = addAllowedPrefixesToDirectConnectGateway, virtualGatewayId = virtualGatewayId)
  output <- .directconnect$create_direct_connect_gateway_association_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_direct_connect_gateway_association <- directconnect_create_direct_connect_gateway_association

#' Creates a proposal to associate the specified virtual private gateway or
#' transit gateway with the specified Direct Connect gateway
#'
#' Creates a proposal to associate the specified virtual private gateway or
#' transit gateway with the specified Direct Connect gateway.
#' 
#' You can only associate a Direct Connect gateway and virtual private
#' gateway or transit gateway when the account that owns the Direct Connect
#' gateway and the account that owns the virtual private gateway or transit
#' gateway have the same AWS Payer ID.
#'
#' @usage
#' directconnect_create_direct_connect_gateway_association_proposal(
#'   directConnectGatewayId, directConnectGatewayOwnerAccount, gatewayId,
#'   addAllowedPrefixesToDirectConnectGateway,
#'   removeAllowedPrefixesToDirectConnectGateway)
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#' @param directConnectGatewayOwnerAccount &#91;required&#93; The ID of the AWS account that owns the Direct Connect gateway.
#' @param gatewayId &#91;required&#93; The ID of the virtual private gateway or transit gateway.
#' @param addAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to advertise to the Direct Connect gateway.
#' @param removeAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to no longer advertise to the Direct Connect
#' gateway.
#'
#' @section Request syntax:
#' ```
#' svc$create_direct_connect_gateway_association_proposal(
#'   directConnectGatewayId = "string",
#'   directConnectGatewayOwnerAccount = "string",
#'   gatewayId = "string",
#'   addAllowedPrefixesToDirectConnectGateway = list(
#'     list(
#'       cidr = "string"
#'     )
#'   ),
#'   removeAllowedPrefixesToDirectConnectGateway = list(
#'     list(
#'       cidr = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_direct_connect_gateway_association_proposal
directconnect_create_direct_connect_gateway_association_proposal <- function(directConnectGatewayId, directConnectGatewayOwnerAccount, gatewayId, addAllowedPrefixesToDirectConnectGateway = NULL, removeAllowedPrefixesToDirectConnectGateway = NULL) {
  op <- new_operation(
    name = "CreateDirectConnectGatewayAssociationProposal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_direct_connect_gateway_association_proposal_input(directConnectGatewayId = directConnectGatewayId, directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount, gatewayId = gatewayId, addAllowedPrefixesToDirectConnectGateway = addAllowedPrefixesToDirectConnectGateway, removeAllowedPrefixesToDirectConnectGateway = removeAllowedPrefixesToDirectConnectGateway)
  output <- .directconnect$create_direct_connect_gateway_association_proposal_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_direct_connect_gateway_association_proposal <- directconnect_create_direct_connect_gateway_association_proposal

#' Creates an interconnect between an AWS Direct Connect Partner's network
#' and a specific AWS Direct Connect location
#'
#' Creates an interconnect between an AWS Direct Connect Partner\'s network
#' and a specific AWS Direct Connect location.
#' 
#' An interconnect is a connection that is capable of hosting other
#' connections. The AWS Direct Connect partner can use an interconnect to
#' provide AWS Direct Connect hosted connections to customers through their
#' own network services. Like a standard connection, an interconnect links
#' the partner\'s network to an AWS Direct Connect location over a standard
#' Ethernet fiber-optic cable. One end is connected to the partner\'s
#' router, the other to an AWS Direct Connect router.
#' 
#' You can automatically add the new interconnect to a link aggregation
#' group (LAG) by specifying a LAG ID in the request. This ensures that the
#' new interconnect is allocated on the same AWS Direct Connect endpoint
#' that hosts the specified LAG. If there are no available ports on the
#' endpoint, the request fails and no interconnect is created.
#' 
#' For each end customer, the AWS Direct Connect Partner provisions a
#' connection on their interconnect by calling AllocateHostedConnection.
#' The end customer can then connect to AWS resources by creating a virtual
#' interface on their connection, using the VLAN assigned to them by the
#' AWS Direct Connect Partner.
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_create_interconnect(interconnectName, bandwidth, location,
#'   lagId, tags, providerName)
#'
#' @param interconnectName &#91;required&#93; The name of the interconnect.
#' @param bandwidth &#91;required&#93; The port bandwidth, in Gbps. The possible values are 1 and 10.
#' @param location &#91;required&#93; The location of the interconnect.
#' @param lagId The ID of the LAG.
#' @param tags The tags to associate with the interconnect.
#' @param providerName The name of the service provider associated with the interconnect.
#'
#' @section Request syntax:
#' ```
#' svc$create_interconnect(
#'   interconnectName = "string",
#'   bandwidth = "string",
#'   location = "string",
#'   lagId = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   providerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_interconnect
directconnect_create_interconnect <- function(interconnectName, bandwidth, location, lagId = NULL, tags = NULL, providerName = NULL) {
  op <- new_operation(
    name = "CreateInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_interconnect_input(interconnectName = interconnectName, bandwidth = bandwidth, location = location, lagId = lagId, tags = tags, providerName = providerName)
  output <- .directconnect$create_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_interconnect <- directconnect_create_interconnect

#' Creates a link aggregation group (LAG) with the specified number of
#' bundled physical connections between the customer network and a specific
#' AWS Direct Connect location
#'
#' Creates a link aggregation group (LAG) with the specified number of
#' bundled physical connections between the customer network and a specific
#' AWS Direct Connect location. A LAG is a logical interface that uses the
#' Link Aggregation Control Protocol (LACP) to aggregate multiple
#' interfaces, enabling you to treat them as a single interface.
#' 
#' All connections in a LAG must use the same bandwidth and must terminate
#' at the same AWS Direct Connect endpoint.
#' 
#' You can have up to 10 connections per LAG. Regardless of this limit, if
#' you request more connections for the LAG than AWS Direct Connect can
#' allocate on a single endpoint, no LAG is created.
#' 
#' You can specify an existing physical connection or interconnect to
#' include in the LAG (which counts towards the total number of
#' connections). Doing so interrupts the current physical connection or
#' hosted connections, and re-establishes them as a member of the LAG. The
#' LAG will be created on the same AWS Direct Connect endpoint to which the
#' connection terminates. Any virtual interfaces associated with the
#' connection are automatically disassociated and re-associated with the
#' LAG. The connection ID does not change.
#' 
#' If the AWS account used to create a LAG is a registered AWS Direct
#' Connect Partner, the LAG is automatically enabled to host
#' sub-connections. For a LAG owned by a partner, any associated virtual
#' interfaces cannot be directly configured.
#'
#' @usage
#' directconnect_create_lag(numberOfConnections, location,
#'   connectionsBandwidth, lagName, connectionId, tags, childConnectionTags,
#'   providerName)
#'
#' @param numberOfConnections &#91;required&#93; The number of physical connections initially provisioned and bundled by
#' the LAG.
#' @param location &#91;required&#93; The location for the LAG.
#' @param connectionsBandwidth &#91;required&#93; The bandwidth of the individual physical connections bundled by the LAG.
#' The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps,
#' 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps.
#' @param lagName &#91;required&#93; The name of the LAG.
#' @param connectionId The ID of an existing connection to migrate to the LAG.
#' @param tags The tags to associate with the LAG.
#' @param childConnectionTags The tags to associate with the automtically created LAGs.
#' @param providerName The name of the service provider associated with the LAG.
#'
#' @section Request syntax:
#' ```
#' svc$create_lag(
#'   numberOfConnections = 123,
#'   location = "string",
#'   connectionsBandwidth = "string",
#'   lagName = "string",
#'   connectionId = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   childConnectionTags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   providerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_lag
directconnect_create_lag <- function(numberOfConnections, location, connectionsBandwidth, lagName, connectionId = NULL, tags = NULL, childConnectionTags = NULL, providerName = NULL) {
  op <- new_operation(
    name = "CreateLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_lag_input(numberOfConnections = numberOfConnections, location = location, connectionsBandwidth = connectionsBandwidth, lagName = lagName, connectionId = connectionId, tags = tags, childConnectionTags = childConnectionTags, providerName = providerName)
  output <- .directconnect$create_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_lag <- directconnect_create_lag

#' Creates a private virtual interface
#'
#' Creates a private virtual interface. A virtual interface is the VLAN
#' that transports AWS Direct Connect traffic. A private virtual interface
#' can be connected to either a Direct Connect gateway or a Virtual Private
#' Gateway (VGW). Connecting the private virtual interface to a Direct
#' Connect gateway enables the possibility for connecting to multiple VPCs,
#' including VPCs in different AWS Regions. Connecting the private virtual
#' interface to a VGW only provides access to a single VPC within the same
#' Region.
#' 
#' Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause
#' an update to the underlying physical connection if it wasn\'t updated to
#' support jumbo frames. Updating the connection disrupts network
#' connectivity for all virtual interfaces associated with the connection
#' for up to 30 seconds. To check whether your connection supports jumbo
#' frames, call DescribeConnections. To check whether your virtual
#' interface supports jumbo frames, call DescribeVirtualInterfaces.
#'
#' @usage
#' directconnect_create_private_virtual_interface(connectionId,
#'   newPrivateVirtualInterface)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param newPrivateVirtualInterface &#91;required&#93; Information about the private virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$create_private_virtual_interface(
#'   connectionId = "string",
#'   newPrivateVirtualInterface = list(
#'     virtualInterfaceName = "string",
#'     vlan = 123,
#'     asn = 123,
#'     mtu = 123,
#'     authKey = "string",
#'     amazonAddress = "string",
#'     customerAddress = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     virtualGatewayId = "string",
#'     directConnectGatewayId = "string",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_private_virtual_interface
directconnect_create_private_virtual_interface <- function(connectionId, newPrivateVirtualInterface) {
  op <- new_operation(
    name = "CreatePrivateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_private_virtual_interface_input(connectionId = connectionId, newPrivateVirtualInterface = newPrivateVirtualInterface)
  output <- .directconnect$create_private_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_private_virtual_interface <- directconnect_create_private_virtual_interface

#' Creates a public virtual interface
#'
#' Creates a public virtual interface. A virtual interface is the VLAN that
#' transports AWS Direct Connect traffic. A public virtual interface
#' supports sending traffic to public services of AWS such as Amazon S3.
#' 
#' When creating an IPv6 public virtual interface (`addressFamily` is
#' `ipv6`), leave the `customer` and `amazon` address fields blank to use
#' auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
#'
#' @usage
#' directconnect_create_public_virtual_interface(connectionId,
#'   newPublicVirtualInterface)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param newPublicVirtualInterface &#91;required&#93; Information about the public virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$create_public_virtual_interface(
#'   connectionId = "string",
#'   newPublicVirtualInterface = list(
#'     virtualInterfaceName = "string",
#'     vlan = 123,
#'     asn = 123,
#'     authKey = "string",
#'     amazonAddress = "string",
#'     customerAddress = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     routeFilterPrefixes = list(
#'       list(
#'         cidr = "string"
#'       )
#'     ),
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_public_virtual_interface
directconnect_create_public_virtual_interface <- function(connectionId, newPublicVirtualInterface) {
  op <- new_operation(
    name = "CreatePublicVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_public_virtual_interface_input(connectionId = connectionId, newPublicVirtualInterface = newPublicVirtualInterface)
  output <- .directconnect$create_public_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_public_virtual_interface <- directconnect_create_public_virtual_interface

#' Creates a transit virtual interface
#'
#' Creates a transit virtual interface. A transit virtual interface should
#' be used to access one or more transit gateways associated with Direct
#' Connect gateways. A transit virtual interface enables the connection of
#' multiple VPCs attached to a transit gateway to a Direct Connect gateway.
#' 
#' If you associate your transit gateway with one or more Direct Connect
#' gateways, the Autonomous System Number (ASN) used by the transit gateway
#' and the Direct Connect gateway must be different. For example, if you
#' use the default ASN 64512 for both your the transit gateway and Direct
#' Connect gateway, the association request fails.
#' 
#' Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause
#' an update to the underlying physical connection if it wasn\'t updated to
#' support jumbo frames. Updating the connection disrupts network
#' connectivity for all virtual interfaces associated with the connection
#' for up to 30 seconds. To check whether your connection supports jumbo
#' frames, call DescribeConnections. To check whether your virtual
#' interface supports jumbo frames, call DescribeVirtualInterfaces.
#'
#' @usage
#' directconnect_create_transit_virtual_interface(connectionId,
#'   newTransitVirtualInterface)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param newTransitVirtualInterface &#91;required&#93; Information about the transit virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_virtual_interface(
#'   connectionId = "string",
#'   newTransitVirtualInterface = list(
#'     virtualInterfaceName = "string",
#'     vlan = 123,
#'     asn = 123,
#'     mtu = 123,
#'     authKey = "string",
#'     amazonAddress = "string",
#'     customerAddress = "string",
#'     addressFamily = "ipv4"|"ipv6",
#'     directConnectGatewayId = "string",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_create_transit_virtual_interface
directconnect_create_transit_virtual_interface <- function(connectionId, newTransitVirtualInterface) {
  op <- new_operation(
    name = "CreateTransitVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_transit_virtual_interface_input(connectionId = connectionId, newTransitVirtualInterface = newTransitVirtualInterface)
  output <- .directconnect$create_transit_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_transit_virtual_interface <- directconnect_create_transit_virtual_interface

#' Deletes the specified BGP peer on the specified virtual interface with
#' the specified customer address and ASN
#'
#' Deletes the specified BGP peer on the specified virtual interface with
#' the specified customer address and ASN.
#' 
#' You cannot delete the last BGP peer from a virtual interface.
#'
#' @usage
#' directconnect_delete_bgp_peer(virtualInterfaceId, asn, customerAddress,
#'   bgpPeerId)
#'
#' @param virtualInterfaceId The ID of the virtual interface.
#' @param asn The autonomous system (AS) number for Border Gateway Protocol (BGP)
#' configuration.
#' @param customerAddress The IP address assigned to the customer interface.
#' @param bgpPeerId The ID of the BGP peer.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bgp_peer(
#'   virtualInterfaceId = "string",
#'   asn = 123,
#'   customerAddress = "string",
#'   bgpPeerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_bgp_peer
directconnect_delete_bgp_peer <- function(virtualInterfaceId = NULL, asn = NULL, customerAddress = NULL, bgpPeerId = NULL) {
  op <- new_operation(
    name = "DeleteBGPPeer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_bgp_peer_input(virtualInterfaceId = virtualInterfaceId, asn = asn, customerAddress = customerAddress, bgpPeerId = bgpPeerId)
  output <- .directconnect$delete_bgp_peer_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_bgp_peer <- directconnect_delete_bgp_peer

#' Deletes the specified connection
#'
#' Deletes the specified connection.
#' 
#' Deleting a connection only stops the AWS Direct Connect port hour and
#' data transfer charges. If you are partnering with any third parties to
#' connect with the AWS Direct Connect location, you must cancel your
#' service with them separately.
#'
#' @usage
#' directconnect_delete_connection(connectionId)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#'
#' @section Request syntax:
#' ```
#' svc$delete_connection(
#'   connectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_connection
directconnect_delete_connection <- function(connectionId) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_connection_input(connectionId = connectionId)
  output <- .directconnect$delete_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_connection <- directconnect_delete_connection

#' Deletes the specified Direct Connect gateway
#'
#' Deletes the specified Direct Connect gateway. You must first delete all
#' virtual interfaces that are attached to the Direct Connect gateway and
#' disassociate all virtual private gateways associated with the Direct
#' Connect gateway.
#'
#' @usage
#' directconnect_delete_direct_connect_gateway(directConnectGatewayId)
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#'
#' @section Request syntax:
#' ```
#' svc$delete_direct_connect_gateway(
#'   directConnectGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_direct_connect_gateway
directconnect_delete_direct_connect_gateway <- function(directConnectGatewayId) {
  op <- new_operation(
    name = "DeleteDirectConnectGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_direct_connect_gateway_input(directConnectGatewayId = directConnectGatewayId)
  output <- .directconnect$delete_direct_connect_gateway_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_direct_connect_gateway <- directconnect_delete_direct_connect_gateway

#' Deletes the association between the specified Direct Connect gateway and
#' virtual private gateway
#'
#' Deletes the association between the specified Direct Connect gateway and
#' virtual private gateway.
#' 
#' We recommend that you specify the `associationID` to delete the
#' association. Alternatively, if you own virtual gateway and a Direct
#' Connect gateway association, you can specify the `virtualGatewayId` and
#' `directConnectGatewayId` to delete an association.
#'
#' @usage
#' directconnect_delete_direct_connect_gateway_association(associationId,
#'   directConnectGatewayId, virtualGatewayId)
#'
#' @param associationId The ID of the Direct Connect gateway association.
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param virtualGatewayId The ID of the virtual private gateway.
#'
#' @section Request syntax:
#' ```
#' svc$delete_direct_connect_gateway_association(
#'   associationId = "string",
#'   directConnectGatewayId = "string",
#'   virtualGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_direct_connect_gateway_association
directconnect_delete_direct_connect_gateway_association <- function(associationId = NULL, directConnectGatewayId = NULL, virtualGatewayId = NULL) {
  op <- new_operation(
    name = "DeleteDirectConnectGatewayAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_direct_connect_gateway_association_input(associationId = associationId, directConnectGatewayId = directConnectGatewayId, virtualGatewayId = virtualGatewayId)
  output <- .directconnect$delete_direct_connect_gateway_association_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_direct_connect_gateway_association <- directconnect_delete_direct_connect_gateway_association

#' Deletes the association proposal request between the specified Direct
#' Connect gateway and virtual private gateway or transit gateway
#'
#' Deletes the association proposal request between the specified Direct
#' Connect gateway and virtual private gateway or transit gateway.
#'
#' @usage
#' directconnect_delete_direct_connect_gateway_association_proposal(
#'   proposalId)
#'
#' @param proposalId &#91;required&#93; The ID of the proposal.
#'
#' @section Request syntax:
#' ```
#' svc$delete_direct_connect_gateway_association_proposal(
#'   proposalId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_direct_connect_gateway_association_proposal
directconnect_delete_direct_connect_gateway_association_proposal <- function(proposalId) {
  op <- new_operation(
    name = "DeleteDirectConnectGatewayAssociationProposal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_direct_connect_gateway_association_proposal_input(proposalId = proposalId)
  output <- .directconnect$delete_direct_connect_gateway_association_proposal_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_direct_connect_gateway_association_proposal <- directconnect_delete_direct_connect_gateway_association_proposal

#' Deletes the specified interconnect
#'
#' Deletes the specified interconnect.
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_delete_interconnect(interconnectId)
#'
#' @param interconnectId &#91;required&#93; The ID of the interconnect.
#'
#' @section Request syntax:
#' ```
#' svc$delete_interconnect(
#'   interconnectId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_interconnect
directconnect_delete_interconnect <- function(interconnectId) {
  op <- new_operation(
    name = "DeleteInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_interconnect_input(interconnectId = interconnectId)
  output <- .directconnect$delete_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_interconnect <- directconnect_delete_interconnect

#' Deletes the specified link aggregation group (LAG)
#'
#' Deletes the specified link aggregation group (LAG). You cannot delete a
#' LAG if it has active virtual interfaces or hosted connections.
#'
#' @usage
#' directconnect_delete_lag(lagId)
#'
#' @param lagId &#91;required&#93; The ID of the LAG.
#'
#' @section Request syntax:
#' ```
#' svc$delete_lag(
#'   lagId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_lag
directconnect_delete_lag <- function(lagId) {
  op <- new_operation(
    name = "DeleteLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_lag_input(lagId = lagId)
  output <- .directconnect$delete_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_lag <- directconnect_delete_lag

#' Deletes a virtual interface
#'
#' Deletes a virtual interface.
#'
#' @usage
#' directconnect_delete_virtual_interface(virtualInterfaceId)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$delete_virtual_interface(
#'   virtualInterfaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_virtual_interface
directconnect_delete_virtual_interface <- function(virtualInterfaceId) {
  op <- new_operation(
    name = "DeleteVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_virtual_interface_input(virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$delete_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_virtual_interface <- directconnect_delete_virtual_interface

#' Deprecated
#'
#' Deprecated. Use DescribeLoa instead.
#' 
#' Gets the LOA-CFA for a connection.
#' 
#' The Letter of Authorization - Connecting Facility Assignment (LOA-CFA)
#' is a document that your APN partner or service provider uses when
#' establishing your cross connect to AWS at the colocation facility. For
#' more information, see [Requesting Cross Connects at AWS Direct Connect
#' Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
#' in the *AWS Direct Connect User Guide*.
#'
#' @usage
#' directconnect_describe_connection_loa(connectionId, providerName,
#'   loaContentType)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param providerName The name of the APN partner or service provider who establishes
#' connectivity on your behalf. If you specify this parameter, the LOA-CFA
#' lists the provider name alongside your company name as the requester of
#' the cross connect.
#' @param loaContentType The standard media type for the LOA-CFA document. The only supported
#' value is application/pdf.
#'
#' @section Request syntax:
#' ```
#' svc$describe_connection_loa(
#'   connectionId = "string",
#'   providerName = "string",
#'   loaContentType = "application/pdf"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_connection_loa
directconnect_describe_connection_loa <- function(connectionId, providerName = NULL, loaContentType = NULL) {
  op <- new_operation(
    name = "DescribeConnectionLoa",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_connection_loa_input(connectionId = connectionId, providerName = providerName, loaContentType = loaContentType)
  output <- .directconnect$describe_connection_loa_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_connection_loa <- directconnect_describe_connection_loa

#' Displays the specified connection or all connections in this Region
#'
#' Displays the specified connection or all connections in this Region.
#'
#' @usage
#' directconnect_describe_connections(connectionId)
#'
#' @param connectionId The ID of the connection.
#'
#' @section Request syntax:
#' ```
#' svc$describe_connections(
#'   connectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_connections
directconnect_describe_connections <- function(connectionId = NULL) {
  op <- new_operation(
    name = "DescribeConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_connections_input(connectionId = connectionId)
  output <- .directconnect$describe_connections_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_connections <- directconnect_describe_connections

#' Deprecated
#'
#' Deprecated. Use DescribeHostedConnections instead.
#' 
#' Lists the connections that have been provisioned on the specified
#' interconnect.
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_describe_connections_on_interconnect(interconnectId)
#'
#' @param interconnectId &#91;required&#93; The ID of the interconnect.
#'
#' @section Request syntax:
#' ```
#' svc$describe_connections_on_interconnect(
#'   interconnectId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_connections_on_interconnect
directconnect_describe_connections_on_interconnect <- function(interconnectId) {
  op <- new_operation(
    name = "DescribeConnectionsOnInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_connections_on_interconnect_input(interconnectId = interconnectId)
  output <- .directconnect$describe_connections_on_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_connections_on_interconnect <- directconnect_describe_connections_on_interconnect

#' Describes one or more association proposals for connection between a
#' virtual private gateway or transit gateway and a Direct Connect gateway
#'
#' Describes one or more association proposals for connection between a
#' virtual private gateway or transit gateway and a Direct Connect gateway.
#'
#' @usage
#' directconnect_describe_direct_connect_gateway_association_proposals(
#'   directConnectGatewayId, proposalId, associatedGatewayId, maxResults,
#'   nextToken)
#'
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param proposalId The ID of the proposal.
#' @param associatedGatewayId The ID of the associated gateway.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_direct_connect_gateway_association_proposals(
#'   directConnectGatewayId = "string",
#'   proposalId = "string",
#'   associatedGatewayId = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateway_association_proposals
directconnect_describe_direct_connect_gateway_association_proposals <- function(directConnectGatewayId = NULL, proposalId = NULL, associatedGatewayId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGatewayAssociationProposals",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateway_association_proposals_input(directConnectGatewayId = directConnectGatewayId, proposalId = proposalId, associatedGatewayId = associatedGatewayId, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$describe_direct_connect_gateway_association_proposals_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateway_association_proposals <- directconnect_describe_direct_connect_gateway_association_proposals

#' Lists the associations between your Direct Connect gateways and virtual
#' private gateways
#'
#' Lists the associations between your Direct Connect gateways and virtual
#' private gateways. You must specify a Direct Connect gateway, a virtual
#' private gateway, or both. If you specify a Direct Connect gateway, the
#' response contains all virtual private gateways associated with the
#' Direct Connect gateway. If you specify a virtual private gateway, the
#' response contains all Direct Connect gateways associated with the
#' virtual private gateway. If you specify both, the response contains the
#' association between the Direct Connect gateway and the virtual private
#' gateway.
#'
#' @usage
#' directconnect_describe_direct_connect_gateway_associations(
#'   associationId, associatedGatewayId, directConnectGatewayId, maxResults,
#'   nextToken, virtualGatewayId)
#'
#' @param associationId The ID of the Direct Connect gateway association.
#' @param associatedGatewayId The ID of the associated gateway.
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token provided in the previous call to retrieve the next page.
#' @param virtualGatewayId The ID of the virtual private gateway.
#'
#' @section Request syntax:
#' ```
#' svc$describe_direct_connect_gateway_associations(
#'   associationId = "string",
#'   associatedGatewayId = "string",
#'   directConnectGatewayId = "string",
#'   maxResults = 123,
#'   nextToken = "string",
#'   virtualGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateway_associations
directconnect_describe_direct_connect_gateway_associations <- function(associationId = NULL, associatedGatewayId = NULL, directConnectGatewayId = NULL, maxResults = NULL, nextToken = NULL, virtualGatewayId = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGatewayAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateway_associations_input(associationId = associationId, associatedGatewayId = associatedGatewayId, directConnectGatewayId = directConnectGatewayId, maxResults = maxResults, nextToken = nextToken, virtualGatewayId = virtualGatewayId)
  output <- .directconnect$describe_direct_connect_gateway_associations_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateway_associations <- directconnect_describe_direct_connect_gateway_associations

#' Lists the attachments between your Direct Connect gateways and virtual
#' interfaces
#'
#' Lists the attachments between your Direct Connect gateways and virtual
#' interfaces. You must specify a Direct Connect gateway, a virtual
#' interface, or both. If you specify a Direct Connect gateway, the
#' response contains all virtual interfaces attached to the Direct Connect
#' gateway. If you specify a virtual interface, the response contains all
#' Direct Connect gateways attached to the virtual interface. If you
#' specify both, the response contains the attachment between the Direct
#' Connect gateway and the virtual interface.
#'
#' @usage
#' directconnect_describe_direct_connect_gateway_attachments(
#'   directConnectGatewayId, virtualInterfaceId, maxResults, nextToken)
#'
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param virtualInterfaceId The ID of the virtual interface.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token provided in the previous call to retrieve the next page.
#'
#' @section Request syntax:
#' ```
#' svc$describe_direct_connect_gateway_attachments(
#'   directConnectGatewayId = "string",
#'   virtualInterfaceId = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateway_attachments
directconnect_describe_direct_connect_gateway_attachments <- function(directConnectGatewayId = NULL, virtualInterfaceId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGatewayAttachments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateway_attachments_input(directConnectGatewayId = directConnectGatewayId, virtualInterfaceId = virtualInterfaceId, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$describe_direct_connect_gateway_attachments_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateway_attachments <- directconnect_describe_direct_connect_gateway_attachments

#' Lists all your Direct Connect gateways or only the specified Direct
#' Connect gateway
#'
#' Lists all your Direct Connect gateways or only the specified Direct
#' Connect gateway. Deleted Direct Connect gateways are not returned.
#'
#' @usage
#' directconnect_describe_direct_connect_gateways(directConnectGatewayId,
#'   maxResults, nextToken)
#'
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token provided in the previous call to retrieve the next page.
#'
#' @section Request syntax:
#' ```
#' svc$describe_direct_connect_gateways(
#'   directConnectGatewayId = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateways
directconnect_describe_direct_connect_gateways <- function(directConnectGatewayId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateways_input(directConnectGatewayId = directConnectGatewayId, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$describe_direct_connect_gateways_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateways <- directconnect_describe_direct_connect_gateways

#' Lists the hosted connections that have been provisioned on the specified
#' interconnect or link aggregation group (LAG)
#'
#' Lists the hosted connections that have been provisioned on the specified
#' interconnect or link aggregation group (LAG).
#' 
#' Intended for use by AWS Direct Connect Partners only.
#'
#' @usage
#' directconnect_describe_hosted_connections(connectionId)
#'
#' @param connectionId &#91;required&#93; The ID of the interconnect or LAG.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hosted_connections(
#'   connectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_hosted_connections
directconnect_describe_hosted_connections <- function(connectionId) {
  op <- new_operation(
    name = "DescribeHostedConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_hosted_connections_input(connectionId = connectionId)
  output <- .directconnect$describe_hosted_connections_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_hosted_connections <- directconnect_describe_hosted_connections

#' Deprecated
#'
#' Deprecated. Use DescribeLoa instead.
#' 
#' Gets the LOA-CFA for the specified interconnect.
#' 
#' The Letter of Authorization - Connecting Facility Assignment (LOA-CFA)
#' is a document that is used when establishing your cross connect to AWS
#' at the colocation facility. For more information, see [Requesting Cross
#' Connects at AWS Direct Connect
#' Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
#' in the *AWS Direct Connect User Guide*.
#'
#' @usage
#' directconnect_describe_interconnect_loa(interconnectId, providerName,
#'   loaContentType)
#'
#' @param interconnectId &#91;required&#93; The ID of the interconnect.
#' @param providerName The name of the service provider who establishes connectivity on your
#' behalf. If you supply this parameter, the LOA-CFA lists the provider
#' name alongside your company name as the requester of the cross connect.
#' @param loaContentType The standard media type for the LOA-CFA document. The only supported
#' value is application/pdf.
#'
#' @section Request syntax:
#' ```
#' svc$describe_interconnect_loa(
#'   interconnectId = "string",
#'   providerName = "string",
#'   loaContentType = "application/pdf"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_interconnect_loa
directconnect_describe_interconnect_loa <- function(interconnectId, providerName = NULL, loaContentType = NULL) {
  op <- new_operation(
    name = "DescribeInterconnectLoa",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_interconnect_loa_input(interconnectId = interconnectId, providerName = providerName, loaContentType = loaContentType)
  output <- .directconnect$describe_interconnect_loa_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_interconnect_loa <- directconnect_describe_interconnect_loa

#' Lists the interconnects owned by the AWS account or only the specified
#' interconnect
#'
#' Lists the interconnects owned by the AWS account or only the specified
#' interconnect.
#'
#' @usage
#' directconnect_describe_interconnects(interconnectId)
#'
#' @param interconnectId The ID of the interconnect.
#'
#' @section Request syntax:
#' ```
#' svc$describe_interconnects(
#'   interconnectId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_interconnects
directconnect_describe_interconnects <- function(interconnectId = NULL) {
  op <- new_operation(
    name = "DescribeInterconnects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_interconnects_input(interconnectId = interconnectId)
  output <- .directconnect$describe_interconnects_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_interconnects <- directconnect_describe_interconnects

#' Describes all your link aggregation groups (LAG) or the specified LAG
#'
#' Describes all your link aggregation groups (LAG) or the specified LAG.
#'
#' @usage
#' directconnect_describe_lags(lagId)
#'
#' @param lagId The ID of the LAG.
#'
#' @section Request syntax:
#' ```
#' svc$describe_lags(
#'   lagId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_lags
directconnect_describe_lags <- function(lagId = NULL) {
  op <- new_operation(
    name = "DescribeLags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_lags_input(lagId = lagId)
  output <- .directconnect$describe_lags_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_lags <- directconnect_describe_lags

#' Gets the LOA-CFA for a connection, interconnect, or link aggregation
#' group (LAG)
#'
#' Gets the LOA-CFA for a connection, interconnect, or link aggregation
#' group (LAG).
#' 
#' The Letter of Authorization - Connecting Facility Assignment (LOA-CFA)
#' is a document that is used when establishing your cross connect to AWS
#' at the colocation facility. For more information, see [Requesting Cross
#' Connects at AWS Direct Connect
#' Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
#' in the *AWS Direct Connect User Guide*.
#'
#' @usage
#' directconnect_describe_loa(connectionId, providerName, loaContentType)
#'
#' @param connectionId &#91;required&#93; The ID of a connection, LAG, or interconnect.
#' @param providerName The name of the service provider who establishes connectivity on your
#' behalf. If you specify this parameter, the LOA-CFA lists the provider
#' name alongside your company name as the requester of the cross connect.
#' @param loaContentType The standard media type for the LOA-CFA document. The only supported
#' value is application/pdf.
#'
#' @section Request syntax:
#' ```
#' svc$describe_loa(
#'   connectionId = "string",
#'   providerName = "string",
#'   loaContentType = "application/pdf"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_loa
directconnect_describe_loa <- function(connectionId, providerName = NULL, loaContentType = NULL) {
  op <- new_operation(
    name = "DescribeLoa",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_loa_input(connectionId = connectionId, providerName = providerName, loaContentType = loaContentType)
  output <- .directconnect$describe_loa_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_loa <- directconnect_describe_loa

#' Lists the AWS Direct Connect locations in the current AWS Region
#'
#' Lists the AWS Direct Connect locations in the current AWS Region. These
#' are the locations that can be selected when calling CreateConnection or
#' CreateInterconnect.
#'
#' @usage
#' directconnect_describe_locations()
#'

#'

#'
#' @keywords internal
#'
#' @rdname directconnect_describe_locations
directconnect_describe_locations <- function() {
  op <- new_operation(
    name = "DescribeLocations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_locations_input()
  output <- .directconnect$describe_locations_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_locations <- directconnect_describe_locations

#' Describes the tags associated with the specified AWS Direct Connect
#' resources
#'
#' Describes the tags associated with the specified AWS Direct Connect
#' resources.
#'
#' @usage
#' directconnect_describe_tags(resourceArns)
#'
#' @param resourceArns &#91;required&#93; The Amazon Resource Names (ARNs) of the resources.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   resourceArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_tags
directconnect_describe_tags <- function(resourceArns) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_tags_input(resourceArns = resourceArns)
  output <- .directconnect$describe_tags_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_tags <- directconnect_describe_tags

#' Lists the virtual private gateways owned by the AWS account
#'
#' Lists the virtual private gateways owned by the AWS account.
#' 
#' You can create one or more AWS Direct Connect private virtual interfaces
#' linked to a virtual private gateway.
#'
#' @usage
#' directconnect_describe_virtual_gateways()
#'

#'

#'
#' @keywords internal
#'
#' @rdname directconnect_describe_virtual_gateways
directconnect_describe_virtual_gateways <- function() {
  op <- new_operation(
    name = "DescribeVirtualGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_virtual_gateways_input()
  output <- .directconnect$describe_virtual_gateways_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_virtual_gateways <- directconnect_describe_virtual_gateways

#' Displays all virtual interfaces for an AWS account
#'
#' Displays all virtual interfaces for an AWS account. Virtual interfaces
#' deleted fewer than 15 minutes before you make the request are also
#' returned. If you specify a connection ID, only the virtual interfaces
#' associated with the connection are returned. If you specify a virtual
#' interface ID, then only a single virtual interface is returned.
#' 
#' A virtual interface (VLAN) transmits the traffic between the AWS Direct
#' Connect location and the customer network.
#'
#' @usage
#' directconnect_describe_virtual_interfaces(connectionId,
#'   virtualInterfaceId)
#'
#' @param connectionId The ID of the connection.
#' @param virtualInterfaceId The ID of the virtual interface.
#'
#' @section Request syntax:
#' ```
#' svc$describe_virtual_interfaces(
#'   connectionId = "string",
#'   virtualInterfaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_virtual_interfaces
directconnect_describe_virtual_interfaces <- function(connectionId = NULL, virtualInterfaceId = NULL) {
  op <- new_operation(
    name = "DescribeVirtualInterfaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_virtual_interfaces_input(connectionId = connectionId, virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$describe_virtual_interfaces_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_virtual_interfaces <- directconnect_describe_virtual_interfaces

#' Disassociates a connection from a link aggregation group (LAG)
#'
#' Disassociates a connection from a link aggregation group (LAG). The
#' connection is interrupted and re-established as a standalone connection
#' (the connection is not deleted; to delete the connection, use the
#' DeleteConnection request). If the LAG has associated virtual interfaces
#' or hosted connections, they remain associated with the LAG. A
#' disassociated connection owned by an AWS Direct Connect Partner is
#' automatically converted to an interconnect.
#' 
#' If disassociating the connection would cause the LAG to fall below its
#' setting for minimum number of operational connections, the request
#' fails, except when it\'s the last member of the LAG. If all connections
#' are disassociated, the LAG continues to exist as an empty LAG with no
#' physical connections.
#'
#' @usage
#' directconnect_disassociate_connection_from_lag(connectionId, lagId)
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param lagId &#91;required&#93; The ID of the LAG.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_connection_from_lag(
#'   connectionId = "string",
#'   lagId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_disassociate_connection_from_lag
directconnect_disassociate_connection_from_lag <- function(connectionId, lagId) {
  op <- new_operation(
    name = "DisassociateConnectionFromLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$disassociate_connection_from_lag_input(connectionId = connectionId, lagId = lagId)
  output <- .directconnect$disassociate_connection_from_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$disassociate_connection_from_lag <- directconnect_disassociate_connection_from_lag

#' Lists the virtual interface failover test history
#'
#' Lists the virtual interface failover test history.
#'
#' @usage
#' directconnect_list_virtual_interface_test_history(testId,
#'   virtualInterfaceId, bgpPeers, status, maxResults, nextToken)
#'
#' @param testId The ID of the virtual interface failover test.
#' @param virtualInterfaceId The ID of the virtual interface that was tested.
#' @param bgpPeers The BGP peers that were placed in the DOWN state during the virtual
#' interface failover test.
#' @param status The status of the virtual interface failover test.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_virtual_interface_test_history(
#'   testId = "string",
#'   virtualInterfaceId = "string",
#'   bgpPeers = list(
#'     "string"
#'   ),
#'   status = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_list_virtual_interface_test_history
directconnect_list_virtual_interface_test_history <- function(testId = NULL, virtualInterfaceId = NULL, bgpPeers = NULL, status = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualInterfaceTestHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$list_virtual_interface_test_history_input(testId = testId, virtualInterfaceId = virtualInterfaceId, bgpPeers = bgpPeers, status = status, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$list_virtual_interface_test_history_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$list_virtual_interface_test_history <- directconnect_list_virtual_interface_test_history

#' Starts the virtual interface failover test that verifies your
#' configuration meets your resiliency requirements by placing the BGP
#' peering session in the DOWN state
#'
#' Starts the virtual interface failover test that verifies your
#' configuration meets your resiliency requirements by placing the BGP
#' peering session in the DOWN state. You can then send traffic to verify
#' that there are no outages.
#' 
#' You can run the test on public, private, transit, and hosted virtual
#' interfaces.
#' 
#' You can use
#' [ListVirtualInterfaceTestHistory](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html)
#' to view the virtual interface test history.
#' 
#' If you need to stop the test before the test interval completes, use
#' [StopBgpFailoverTest](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
#'
#' @usage
#' directconnect_start_bgp_failover_test(virtualInterfaceId, bgpPeers,
#'   testDurationInMinutes)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface you want to test.
#' @param bgpPeers The BGP peers to place in the DOWN state.
#' @param testDurationInMinutes The time in minutes that the virtual interface failover test will last.
#' 
#' Maximum value: 180 minutes (3 hours).
#' 
#' Default: 180 minutes (3 hours).
#'
#' @section Request syntax:
#' ```
#' svc$start_bgp_failover_test(
#'   virtualInterfaceId = "string",
#'   bgpPeers = list(
#'     "string"
#'   ),
#'   testDurationInMinutes = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_start_bgp_failover_test
directconnect_start_bgp_failover_test <- function(virtualInterfaceId, bgpPeers = NULL, testDurationInMinutes = NULL) {
  op <- new_operation(
    name = "StartBgpFailoverTest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$start_bgp_failover_test_input(virtualInterfaceId = virtualInterfaceId, bgpPeers = bgpPeers, testDurationInMinutes = testDurationInMinutes)
  output <- .directconnect$start_bgp_failover_test_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$start_bgp_failover_test <- directconnect_start_bgp_failover_test

#' Stops the virtual interface failover test
#'
#' Stops the virtual interface failover test.
#'
#' @usage
#' directconnect_stop_bgp_failover_test(virtualInterfaceId)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface you no longer want to test.
#'
#' @section Request syntax:
#' ```
#' svc$stop_bgp_failover_test(
#'   virtualInterfaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_stop_bgp_failover_test
directconnect_stop_bgp_failover_test <- function(virtualInterfaceId) {
  op <- new_operation(
    name = "StopBgpFailoverTest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$stop_bgp_failover_test_input(virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$stop_bgp_failover_test_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$stop_bgp_failover_test <- directconnect_stop_bgp_failover_test

#' Adds the specified tags to the specified AWS Direct Connect resource
#'
#' Adds the specified tags to the specified AWS Direct Connect resource.
#' Each resource can have a maximum of 50 tags.
#' 
#' Each tag consists of a key and an optional value. If a tag with the same
#' key is already associated with the resource, this action updates its
#' value.
#'
#' @usage
#' directconnect_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags to add.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_tag_resource
directconnect_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .directconnect$tag_resource_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$tag_resource <- directconnect_tag_resource

#' Removes one or more tags from the specified AWS Direct Connect resource
#'
#' Removes one or more tags from the specified AWS Direct Connect resource.
#'
#' @usage
#' directconnect_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys of the tags to remove.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_untag_resource
directconnect_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .directconnect$untag_resource_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$untag_resource <- directconnect_untag_resource

#' Updates the specified attributes of the Direct Connect gateway
#' association
#'
#' Updates the specified attributes of the Direct Connect gateway
#' association.
#' 
#' Add or remove prefixes from the association.
#'
#' @usage
#' directconnect_update_direct_connect_gateway_association(associationId,
#'   addAllowedPrefixesToDirectConnectGateway,
#'   removeAllowedPrefixesToDirectConnectGateway)
#'
#' @param associationId The ID of the Direct Connect gateway association.
#' @param addAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to advertise to the Direct Connect gateway.
#' @param removeAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to no longer advertise to the Direct Connect
#' gateway.
#'
#' @section Request syntax:
#' ```
#' svc$update_direct_connect_gateway_association(
#'   associationId = "string",
#'   addAllowedPrefixesToDirectConnectGateway = list(
#'     list(
#'       cidr = "string"
#'     )
#'   ),
#'   removeAllowedPrefixesToDirectConnectGateway = list(
#'     list(
#'       cidr = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_update_direct_connect_gateway_association
directconnect_update_direct_connect_gateway_association <- function(associationId = NULL, addAllowedPrefixesToDirectConnectGateway = NULL, removeAllowedPrefixesToDirectConnectGateway = NULL) {
  op <- new_operation(
    name = "UpdateDirectConnectGatewayAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_direct_connect_gateway_association_input(associationId = associationId, addAllowedPrefixesToDirectConnectGateway = addAllowedPrefixesToDirectConnectGateway, removeAllowedPrefixesToDirectConnectGateway = removeAllowedPrefixesToDirectConnectGateway)
  output <- .directconnect$update_direct_connect_gateway_association_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_direct_connect_gateway_association <- directconnect_update_direct_connect_gateway_association

#' Updates the attributes of the specified link aggregation group (LAG)
#'
#' Updates the attributes of the specified link aggregation group (LAG).
#' 
#' You can update the following attributes:
#' 
#' -   The name of the LAG.
#' 
#' -   The value for the minimum number of connections that must be
#'     operational for the LAG itself to be operational.
#' 
#' When you create a LAG, the default value for the minimum number of
#' operational connections is zero (0). If you update this value and the
#' number of operational connections falls below the specified value, the
#' LAG automatically goes down to avoid over-utilization of the remaining
#' connections. Adjust this value with care, as it could force the LAG down
#' if it is set higher than the current number of operational connections.
#'
#' @usage
#' directconnect_update_lag(lagId, lagName, minimumLinks)
#'
#' @param lagId &#91;required&#93; The ID of the LAG.
#' @param lagName The name of the LAG.
#' @param minimumLinks The minimum number of physical connections that must be operational for
#' the LAG itself to be operational.
#'
#' @section Request syntax:
#' ```
#' svc$update_lag(
#'   lagId = "string",
#'   lagName = "string",
#'   minimumLinks = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_update_lag
directconnect_update_lag <- function(lagId, lagName = NULL, minimumLinks = NULL) {
  op <- new_operation(
    name = "UpdateLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_lag_input(lagId = lagId, lagName = lagName, minimumLinks = minimumLinks)
  output <- .directconnect$update_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_lag <- directconnect_update_lag

#' Updates the specified attributes of the specified virtual private
#' interface
#'
#' Updates the specified attributes of the specified virtual private
#' interface.
#' 
#' Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause
#' an update to the underlying physical connection if it wasn\'t updated to
#' support jumbo frames. Updating the connection disrupts network
#' connectivity for all virtual interfaces associated with the connection
#' for up to 30 seconds. To check whether your connection supports jumbo
#' frames, call DescribeConnections. To check whether your virtual q
#' interface supports jumbo frames, call DescribeVirtualInterfaces.
#'
#' @usage
#' directconnect_update_virtual_interface_attributes(virtualInterfaceId,
#'   mtu)
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual private interface.
#' @param mtu The maximum transmission unit (MTU), in bytes. The supported values are
#' 1500 and 9001. The default value is 1500.
#'
#' @section Request syntax:
#' ```
#' svc$update_virtual_interface_attributes(
#'   virtualInterfaceId = "string",
#'   mtu = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directconnect_update_virtual_interface_attributes
directconnect_update_virtual_interface_attributes <- function(virtualInterfaceId, mtu = NULL) {
  op <- new_operation(
    name = "UpdateVirtualInterfaceAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_virtual_interface_attributes_input(virtualInterfaceId = virtualInterfaceId, mtu = mtu)
  output <- .directconnect$update_virtual_interface_attributes_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_virtual_interface_attributes <- directconnect_update_virtual_interface_attributes
