% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_check_domain_transferability}
\alias{route53domains_check_domain_transferability}
\title{Checks whether a domain name can be transferred to Amazon Route 53}
\usage{
route53domains_check_domain_transferability(DomainName, AuthCode)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to transfer to Amazon Route 53.

Constraints: The domain name can contain only the letters a through z,
the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
are not supported.}

\item{AuthCode}{If the registrar for the top-level domain (TLD) requires an
authorization code to transfer the domain, the code that you got from
the current registrar for the domain.}
}
\description{
Checks whether a domain name can be transferred to Amazon Route 53.
}
\section{Request syntax}{
\preformatted{svc$check_domain_transferability(
  DomainName = "string",
  AuthCode = "string"
)
}
}

\keyword{internal}
