% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_allocate_private_virtual_interface}
\alias{directconnect_allocate_private_virtual_interface}
\title{Provisions a private virtual interface to be owned by the specified AWS
account}
\usage{
directconnect_allocate_private_virtual_interface(connectionId,
  ownerAccount, newPrivateVirtualInterfaceAllocation)
}
\arguments{
\item{connectionId}{[required] The ID of the connection on which the private virtual interface is
provisioned.}

\item{ownerAccount}{[required] The ID of the AWS account that owns the virtual private interface.}

\item{newPrivateVirtualInterfaceAllocation}{[required] Information about the private virtual interface.}
}
\description{
Provisions a private virtual interface to be owned by the specified AWS
account.
}
\details{
Virtual interfaces created using this action must be confirmed by the
owner using ConfirmPrivateVirtualInterface. Until then, the virtual
interface is in the \code{Confirming} state and is not available to handle
traffic.
}
\section{Request syntax}{
\preformatted{svc$allocate_private_virtual_interface(
  connectionId = "string",
  ownerAccount = "string",
  newPrivateVirtualInterfaceAllocation = list(
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    mtu = 123,
    authKey = "string",
    amazonAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    customerAddress = "string",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
