% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_traffic_policies}
\alias{route53_list_traffic_policies}
\title{Gets information about the latest version for every traffic policy that
is associated with the current AWS account}
\usage{
route53_list_traffic_policies(TrafficPolicyIdMarker, MaxItems)
}
\arguments{
\item{TrafficPolicyIdMarker}{(Conditional) For your first request to
\code{\link[=route53_list_traffic_policies]{list_traffic_policies}}, don't include
the \code{TrafficPolicyIdMarker} parameter.

If you have more traffic policies than the value of \code{MaxItems},
\code{\link[=route53_list_traffic_policies]{list_traffic_policies}} returns only
the first \code{MaxItems} traffic policies. To get the next group of
policies, submit another request to
\code{\link[=route53_list_traffic_policies]{list_traffic_policies}}. For the value
of \code{TrafficPolicyIdMarker}, specify the value of \code{TrafficPolicyIdMarker}
that was returned in the previous response.}

\item{MaxItems}{(Optional) The maximum number of traffic policies that you want Amazon
Route 53 to return in response to this request. If you have more than
\code{MaxItems} traffic policies, the value of \code{IsTruncated} in the response
is \code{true}, and the value of \code{TrafficPolicyIdMarker} is the ID of the
first traffic policy that Route 53 will return if you submit another
request.}
}
\value{
A list with the following syntax:\preformatted{list(
  TrafficPolicySummaries = list(
    list(
      Id = "string",
      Name = "string",
      Type = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
      LatestVersion = 123,
      TrafficPolicyCount = 123
    )
  ),
  IsTruncated = TRUE|FALSE,
  TrafficPolicyIdMarker = "string",
  MaxItems = "string"
)
}
}
\description{
Gets information about the latest version for every traffic policy that
is associated with the current AWS account. Policies are listed in the
order that they were created in.

For information about how of deleting a traffic policy affects the
response from \code{\link[=route53_list_traffic_policies]{list_traffic_policies}},
see \code{\link[=route53_delete_traffic_policy]{delete_traffic_policy}}.
}
\section{Request syntax}{
\preformatted{svc$list_traffic_policies(
  TrafficPolicyIdMarker = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
