% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_query_log_configs}
\alias{route53resolver_list_resolver_query_log_configs}
\title{Lists information about the specified query logging configurations}
\usage{
route53resolver_list_resolver_query_log_configs(MaxResults, NextToken,
  Filters, SortBy, SortOrder)
}
\arguments{
\item{MaxResults}{The maximum number of query logging configurations that you want to
return in the response to a \code{ListResolverQueryLogConfigs} request. If
you don't specify a value for \code{MaxResults}, Resolver returns up to 100
query logging configurations.}

\item{NextToken}{For the first \code{ListResolverQueryLogConfigs} request, omit this value.

If there are more than \code{MaxResults} query logging configurations that
match the values that you specify for \code{Filters}, you can submit another
\code{ListResolverQueryLogConfigs} request to get the next group of
configurations. In the next request, specify the value of \code{NextToken}
from the previous response.}

\item{Filters}{An optional specification to return a subset of query logging
configurations.

If you submit a second or subsequent \code{ListResolverQueryLogConfigs}
request and specify the \code{NextToken} parameter, you must use the same
values for \code{Filters}, if any, as in the previous request.}

\item{SortBy}{The element that you want Resolver to sort query logging configurations
by.

If you submit a second or subsequent \code{ListResolverQueryLogConfigs}
request and specify the \code{NextToken} parameter, you must use the same
value for \code{SortBy}, if any, as in the previous request.

Valid values include the following elements:
\itemize{
\item \code{Arn}: The ARN of the query logging configuration
\item \code{AssociationCount}: The number of VPCs that are associated with the
specified configuration
\item \code{CreationTime}: The date and time that Resolver returned when the
configuration was created
\item \code{CreatorRequestId}: The value that was specified for
\code{CreatorRequestId} when the configuration was created
\item \code{DestinationArn}: The location that logs are sent to
\item \code{Id}: The ID of the configuration
\item \code{Name}: The name of the configuration
\item \code{OwnerId}: The AWS account number of the account that created the
configuration
\item \code{ShareStatus}: Whether the configuration is shared with other AWS
accounts or shared with the current account by another AWS account.
Sharing is configured through AWS Resource Access Manager (AWS RAM).
\item \code{Status}: The current status of the configuration. Valid values
include the following:
\itemize{
\item \code{CREATING}: Resolver is creating the query logging
configuration.
\item \code{CREATED}: The query logging configuration was successfully
created. Resolver is logging queries that originate in the
specified VPC.
\item \code{DELETING}: Resolver is deleting this query logging
configuration.
\item \code{FAILED}: Resolver either couldn't create or couldn't delete the
query logging configuration. Here are two common causes:
\itemize{
\item The specified destination (for example, an Amazon S3 bucket)
was deleted.
\item Permissions don't allow sending logs to the destination.
}
}
}}

\item{SortOrder}{If you specified a value for \code{SortBy}, the order that you want query
logging configurations to be listed in, \code{ASCENDING} or \code{DESCENDING}.

If you submit a second or subsequent \code{ListResolverQueryLogConfigs}
request and specify the \code{NextToken} parameter, you must use the same
value for \code{SortOrder}, if any, as in the previous request.}
}
\description{
Lists information about the specified query logging configurations. Each
configuration defines where you want Resolver to save DNS query logs and
specifies the VPCs that you want to log queries for.
}
\section{Request syntax}{
\preformatted{svc$list_resolver_query_log_configs(
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  SortBy = "string",
  SortOrder = "ASCENDING"|"DESCENDING"
)
}
}

\keyword{internal}
