% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_set_rule_priorities}
\alias{elbv2_set_rule_priorities}
\title{Sets the priorities of the specified rules}
\usage{
elbv2_set_rule_priorities(RulePriorities)
}
\arguments{
\item{RulePriorities}{[required] The rule priorities.}
}
\description{
Sets the priorities of the specified rules.

You can reorder the rules as long as there are no priority conflicts in
the new order. Any existing rules that you do not specify retain their
current priority.
}
\section{Request syntax}{
\preformatted{svc$set_rule_priorities(
  RulePriorities = list(
    list(
      RuleArn = "string",
      Priority = 123
    )
  )
)
}
}

\examples{
\dontrun{
# This example sets the priority of the specified rule.
svc$set_rule_priorities(
  RulePriorities = list(
    list(
      Priority = 5L,
      RuleArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-lo..."
    )
  )
)
}

}
\keyword{internal}
