% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_rules}
\alias{elbv2_describe_rules}
\title{Describes the specified rules or the rules for the specified listener}
\usage{
elbv2_describe_rules(ListenerArn, RuleArns, Marker, PageSize)
}
\arguments{
\item{ListenerArn}{The Amazon Resource Name (ARN) of the listener.}

\item{RuleArns}{The Amazon Resource Names (ARN) of the rules.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call.}
}
\description{
Describes the specified rules or the rules for the specified listener.
You must specify either a listener or one or more rules.
}
\section{Request syntax}{
\preformatted{svc$describe_rules(
  ListenerArn = "string",
  RuleArns = list(
    "string"
  ),
  Marker = "string",
  PageSize = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified rule.
svc$describe_rules(
  RuleArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-load-balancer/..."
  )
)
}

}
\keyword{internal}
