% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_create_key_group}
\alias{cloudfront_create_key_group}
\title{Creates a key group that you can use with CloudFront signed URLs and
signed cookies}
\usage{
cloudfront_create_key_group(KeyGroupConfig)
}
\arguments{
\item{KeyGroupConfig}{[required] A key group configuration.}
}
\description{
Creates a key group that you can use with \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html}{CloudFront signed URLs and signed cookies}.

To create a key group, you must specify at least one public key for the
key group. After you create a key group, you can reference it from one
or more cache behaviors. When you reference a key group in a cache
behavior, CloudFront requires signed URLs or signed cookies for all
requests that match the cache behavior. The URLs or cookies must be
signed with a private key whose corresponding public key is in the key
group. The signed URL or cookie contains information about which public
key CloudFront should use to verify the signature. For more information,
see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html}{Serving private content}
in the \emph{Amazon CloudFront Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_key_group(
  KeyGroupConfig = list(
    Name = "string",
    Items = list(
      "string"
    ),
    Comment = "string"
  )
)
}
}

\keyword{internal}
