% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_deployment}
\alias{apigateway_create_deployment}
\title{Creates a Deployment resource, which makes a specified RestApi callable
over the internet}
\usage{
apigateway_create_deployment(restApiId, stageName, stageDescription,
  description, cacheClusterEnabled, cacheClusterSize, variables,
  canarySettings, tracingEnabled)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{stageName}{The name of the Stage resource for the Deployment resource to create.}

\item{stageDescription}{The description of the Stage resource for the Deployment resource to
create.}

\item{description}{The description for the Deployment resource to create.}

\item{cacheClusterEnabled}{Enables a cache cluster for the Stage resource specified in the input.}

\item{cacheClusterSize}{Specifies the cache cluster size for the Stage resource specified in the
input, if a cache cluster is enabled.}

\item{variables}{A map that defines the stage variables for the Stage resource that is
associated with the new deployment. Variable names can have alphanumeric
and underscore characters, and the values must match
\verb{\\\[A-Za-z0-9-._~:/?#&amp;=,\\\]+}.}

\item{canarySettings}{The input configuration for the canary deployment when the deployment is
a canary release deployment.}

\item{tracingEnabled}{Specifies whether active tracing with X-ray is enabled for the Stage.}
}
\description{
Creates a Deployment resource, which makes a specified RestApi callable
over the internet.
}
\section{Request syntax}{
\preformatted{svc$create_deployment(
  restApiId = "string",
  stageName = "string",
  stageDescription = "string",
  description = "string",
  cacheClusterEnabled = TRUE|FALSE,
  cacheClusterSize = "0.5"|"1.6"|"6.1"|"13.5"|"28.4"|"58.2"|"118"|"237",
  variables = list(
    "string"
  ),
  canarySettings = list(
    percentTraffic = 123.0,
    stageVariableOverrides = list(
      "string"
    ),
    useStageCache = TRUE|FALSE
  ),
  tracingEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
