% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_check_domain_availability}
\alias{route53domains_check_domain_availability}
\title{This operation checks the availability of one domain name}
\usage{
route53domains_check_domain_availability(DomainName, IdnLangCode)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to get availability for.

Constraints: The domain name can contain only the letters a through z,
the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
are not supported.}

\item{IdnLangCode}{Reserved for future use.}
}
\description{
This operation checks the availability of one domain name. Note that if
the availability status of a domain is pending, you must submit another
request to determine the availability of the domain name.
}
\section{Request syntax}{
\preformatted{svc$check_domain_availability(
  DomainName = "string",
  IdnLangCode = "string"
)
}
}

\keyword{internal}
