% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_add_listener_certificates}
\alias{elbv2_add_listener_certificates}
\title{Adds the specified certificate to the specified HTTPS listener}
\usage{
elbv2_add_listener_certificates(ListenerArn, Certificates)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{Certificates}{[required] The certificate to add. You can specify one certificate per call. Set
\code{CertificateArn} to the certificate ARN but do not set \code{IsDefault}.}
}
\description{
Adds the specified certificate to the specified HTTPS listener.
}
\details{
If the certificate was already added, the call is successful but the
certificate is not added again.

To list the certificates for your listener, use
DescribeListenerCertificates. To remove certificates from your listener,
use RemoveListenerCertificates. To specify the default SSL server
certificate, use ModifyListener.
}
\section{Request syntax}{
\preformatted{svc$add_listener_certificates(
  ListenerArn = "string",
  Certificates = list(
    list(
      CertificateArn = "string",
      IsDefault = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
