% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_event_aggregates}
\alias{health_describe_event_aggregates}
\title{Returns the number of events of each event type (issue, scheduled
change, and account notification)}
\usage{
health_describe_event_aggregates(filter, aggregateField, maxResults,
  nextToken)
}
\arguments{
\item{filter}{Values to narrow the results returned.}

\item{aggregateField}{[required] The only currently supported value is \code{eventTypeCategory}.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}
}
\description{
Returns the number of events of each event type (issue, scheduled
change, and account notification). If no filter is specified, the counts
of all events in each category are returned.
}
\section{Request syntax}{
\preformatted{svc$describe_event_aggregates(
  filter = list(
    eventArns = list(
      "string"
    ),
    eventTypeCodes = list(
      "string"
    ),
    services = list(
      "string"
    ),
    regions = list(
      "string"
    ),
    availabilityZones = list(
      "string"
    ),
    startTimes = list(
      list(
        from = as.POSIXct(
          "2015-01-01"
        ),
        to = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    endTimes = list(
      list(
        from = as.POSIXct(
          "2015-01-01"
        ),
        to = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    lastUpdatedTimes = list(
      list(
        from = as.POSIXct(
          "2015-01-01"
        ),
        to = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    entityArns = list(
      "string"
    ),
    entityValues = list(
      "string"
    ),
    eventTypeCategories = list(
      "issue"|"accountNotification"|"scheduledChange"|"investigation"
    ),
    tags = list(
      list(
        "string"
      )
    ),
    eventStatusCodes = list(
      "open"|"closed"|"upcoming"
    )
  ),
  aggregateField = "eventTypeCategory",
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
