% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_stack_instances}
\alias{cloudformation_list_stack_instances}
\title{Returns summary information about stack instances that are associated
with the specified stack set}
\usage{
cloudformation_list_stack_instances(StackSetName, NextToken, MaxResults,
  Filters, StackInstanceAccount, StackInstanceRegion)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to list stack
instances for.}

\item{NextToken}{If the previous request didn\'t return all of the remaining results, the
response\'s \code{NextToken} parameter value is set to a token. To retrieve
the next set of results, call \code{ListStackInstances} again and assign that
token to the request object\'s \code{NextToken} parameter. If there are no
remaining results, the previous response object\'s \code{NextToken} parameter
is set to \code{null}.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}

\item{Filters}{The status that stack instances are filtered by.}

\item{StackInstanceAccount}{The name of the AWS account that you want to list stack instances for.}

\item{StackInstanceRegion}{The name of the Region where you want to list stack instances.}
}
\description{
Returns summary information about stack instances that are associated
with the specified stack set. You can filter for stack instances that
are associated with a specific AWS account name or Region, or that have
a specific status.
}
\section{Request syntax}{
\preformatted{svc$list_stack_instances(
  StackSetName = "string",
  NextToken = "string",
  MaxResults = 123,
  Filters = list(
    list(
      Name = "DETAILED_STATUS",
      Values = "string"
    )
  ),
  StackInstanceAccount = "string",
  StackInstanceRegion = "string"
)
}
}

\keyword{internal}
