% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_describe_load_balancers}
\alias{autoscaling_describe_load_balancers}
\title{Describes the load balancers for the specified Auto Scaling group}
\usage{
autoscaling_describe_load_balancers(AutoScalingGroupName, NextToken,
  MaxRecords)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxRecords}{The maximum number of items to return with this call. The default value
is \code{100} and the maximum value is \code{100}.}
}
\description{
Describes the load balancers for the specified Auto Scaling group.
}
\details{
This operation describes only Classic Load Balancers. If you have
Application Load Balancers or Network Load Balancers, use the
DescribeLoadBalancerTargetGroups API instead.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancers(
  AutoScalingGroupName = "string",
  NextToken = "string",
  MaxRecords = 123
)
}
}

\examples{
\dontrun{
# This example describes the load balancers attached to the specified Auto
# Scaling group.
svc$describe_load_balancers(
  AutoScalingGroupName = "my-auto-scaling-group"
)
}

}
\keyword{internal}
