% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_update_license_specifications_for_resource}
\alias{licensemanager_update_license_specifications_for_resource}
\title{Adds or removes the specified license configurations for the specified
AWS resource}
\usage{
licensemanager_update_license_specifications_for_resource(ResourceArn,
  AddLicenseSpecifications, RemoveLicenseSpecifications)
}
\arguments{
\item{ResourceArn}{[required] Amazon Resource Name (ARN) of the AWS resource.}

\item{AddLicenseSpecifications}{ARNs of the license configurations to add.}

\item{RemoveLicenseSpecifications}{ARNs of the license configurations to remove.}
}
\description{
Adds or removes the specified license configurations for the specified
AWS resource.
}
\details{
You can update the license specifications of AMIs, instances, and hosts.
You cannot update the license specifications for launch templates and
AWS CloudFormation templates, as they send license configurations to the
operation that creates the resource.
}
\section{Request syntax}{
\preformatted{svc$update_license_specifications_for_resource(
  ResourceArn = "string",
  AddLicenseSpecifications = list(
    list(
      LicenseConfigurationArn = "string"
    )
  ),
  RemoveLicenseSpecifications = list(
    list(
      LicenseConfigurationArn = "string"
    )
  )
)
}
}

\keyword{internal}
