% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_license_configurations}
\alias{licensemanager_list_license_configurations}
\title{Lists the license configurations for your account}
\usage{
licensemanager_list_license_configurations(LicenseConfigurationArns,
  MaxResults, NextToken, Filters)
}
\arguments{
\item{LicenseConfigurationArns}{Amazon Resource Names (ARN) of the license configurations.}

\item{MaxResults}{Maximum number of results to return in a single call.}

\item{NextToken}{Token for the next set of results.}

\item{Filters}{Filters to scope the results. The following filters and logical
operators are supported:
\itemize{
\item \code{licenseCountingType} - The dimension on which licenses are counted
(vCPU). Logical operators are \code{EQUALS} \\| \code{NOT_EQUALS}.
\item \code{enforceLicenseCount} - A Boolean value that indicates whether hard
license enforcement is used. Logical operators are \code{EQUALS} \\|
\code{NOT_EQUALS}.
\item \code{usagelimitExceeded} - A Boolean value that indicates whether the
available licenses have been exceeded. Logical operators are
\code{EQUALS} \\| \code{NOT_EQUALS}.
}}
}
\description{
Lists the license configurations for your account.
}
\section{Request syntax}{
\preformatted{svc$list_license_configurations(
  LicenseConfigurationArns = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
