% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_affected_entities_for_organization}
\alias{health_describe_affected_entities_for_organization}
\title{Returns a list of entities that have been affected by one or more events
for one or more accounts in your organization in AWS Organizations,
based on the filter criteria}
\usage{
health_describe_affected_entities_for_organization(
  organizationEntityFilters, locale, nextToken, maxResults)
}
\arguments{
\item{organizationEntityFilters}{[required] A JSON set of elements including the \code{awsAccountId} and the \code{eventArn}.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}
}
\description{
Returns a list of entities that have been affected by one or more events
for one or more accounts in your organization in AWS Organizations,
based on the filter criteria. Entities can refer to individual customer
resources, groups of customer resources, or any other construct,
depending on the AWS service.
}
\details{
At least one event ARN and account ID are required. Results are sorted
by the \code{lastUpdatedTime} of the entity, starting with the most recent.

Before you can call this operation, you must first enable AWS Health to
work with AWS Organizations. To do this, call the
EnableHealthServiceAccessForOrganization operation from your
organization\'s master account.
}
\section{Request syntax}{
\preformatted{svc$describe_affected_entities_for_organization(
  organizationEntityFilters = list(
    list(
      eventArn = "string",
      awsAccountId = "string"
    )
  ),
  locale = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
