% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_search_resources}
\alias{resourcegroups_search_resources}
\title{Returns a list of AWS resource identifiers that matches a specified
query}
\usage{
resourcegroups_search_resources(ResourceQuery, MaxResults, NextToken)
}
\arguments{
\item{ResourceQuery}{[required] The search query, using the same formats that are supported for resource
group definition.}

\item{MaxResults}{The maximum number of group member ARNs returned by \code{SearchResources} in
paginated output. By default, this number is 50.}

\item{NextToken}{The NextToken value that is returned in a paginated \code{SearchResources}
request. To get the next page of results, run the call again, add the
NextToken parameter, and specify the NextToken value.}
}
\description{
Returns a list of AWS resource identifiers that matches a specified
query. The query uses the same format as a resource query in a
CreateGroup or UpdateGroupQuery operation.
}
\section{Request syntax}{
\preformatted{svc$search_resources(
  ResourceQuery = list(
    Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
    Query = "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
