% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_portfolio}
\alias{servicecatalog_update_portfolio}
\title{Updates the specified portfolio}
\usage{
servicecatalog_update_portfolio(AcceptLanguage, Id, DisplayName,
  Description, ProviderName, AddTags, RemoveTags)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{Id}{[required] The portfolio identifier.}

\item{DisplayName}{The name to use for display purposes.}

\item{Description}{The updated description of the portfolio.}

\item{ProviderName}{The updated name of the portfolio provider.}

\item{AddTags}{The tags to add.}

\item{RemoveTags}{The tags to remove.}
}
\value{
A list with the following syntax:\preformatted{list(
  PortfolioDetail = list(
    Id = "string",
    ARN = "string",
    DisplayName = "string",
    Description = "string",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    ProviderName = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Updates the specified portfolio.

You cannot update a product that was shared with you.
}
\section{Request syntax}{
\preformatted{svc$update_portfolio(
  AcceptLanguage = "string",
  Id = "string",
  DisplayName = "string",
  Description = "string",
  ProviderName = "string",
  AddTags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  RemoveTags = list(
    "string"
  )
)
}
}

\keyword{internal}
