% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_portfolio}
\alias{servicecatalog_describe_portfolio}
\title{Gets information about the specified portfolio}
\usage{
servicecatalog_describe_portfolio(AcceptLanguage, Id)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{Id}{[required] The portfolio identifier.}
}
\value{
A list with the following syntax:\preformatted{list(
  PortfolioDetail = list(
    Id = "string",
    ARN = "string",
    DisplayName = "string",
    Description = "string",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    ProviderName = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  TagOptions = list(
    list(
      Key = "string",
      Value = "string",
      Active = TRUE|FALSE,
      Id = "string",
      Owner = "string"
    )
  ),
  Budgets = list(
    list(
      BudgetName = "string"
    )
  )
)
}
}
\description{
Gets information about the specified portfolio.

A delegated admin is authorized to invoke this command.
}
\section{Request syntax}{
\preformatted{svc$describe_portfolio(
  AcceptLanguage = "string",
  Id = "string"
)
}
}

\keyword{internal}
