% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_list_tags}
\alias{opsworks_list_tags}
\title{Returns a list of tags that are applied to the specified stack or layer}
\usage{
opsworks_list_tags(ResourceArn, MaxResults, NextToken)
}
\arguments{
\item{ResourceArn}{[required] The stack or layer's Amazon Resource Number (ARN).}

\item{MaxResults}{Do not use. A validation exception occurs if you add a \code{MaxResults}
parameter to a \code{ListTagsRequest} call.}

\item{NextToken}{Do not use. A validation exception occurs if you add a \code{NextToken}
parameter to a \code{ListTagsRequest} call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of tags that are applied to the specified stack or layer.
}
\section{Request syntax}{
\preformatted{svc$list_tags(
  ResourceArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
