% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_received_licenses}
\alias{licensemanager_list_received_licenses}
\title{Lists received licenses}
\usage{
licensemanager_list_received_licenses(LicenseArns, Filters, NextToken,
  MaxResults)
}
\arguments{
\item{LicenseArns}{Amazon Resource Names (ARNs) of the licenses.}

\item{Filters}{Filters to scope the results. The following filters are supported:
\itemize{
\item \code{ProductSKU}
\item \code{Status}
\item \code{KeyFingerprint}
\item \code{Issuer}
}}

\item{NextToken}{Token for the next set of results.}

\item{MaxResults}{Maximum number of results to return in a single call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Licenses = list(
    list(
      LicenseArn = "string",
      LicenseName = "string",
      ProductName = "string",
      ProductSKU = "string",
      Issuer = list(
        Name = "string",
        SignKey = "string",
        KeyFingerprint = "string"
      ),
      HomeRegion = "string",
      Status = "AVAILABLE"|"PENDING_AVAILABLE"|"DEACTIVATED"|"SUSPENDED"|"EXPIRED"|"PENDING_DELETE"|"DELETED",
      Validity = list(
        Begin = "string",
        End = "string"
      ),
      Beneficiary = "string",
      Entitlements = list(
        list(
          Name = "string",
          Value = "string",
          MaxCount = 123,
          Overage = TRUE|FALSE,
          Unit = "Count"|"None"|"Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second",
          AllowCheckIn = TRUE|FALSE
        )
      ),
      ConsumptionConfiguration = list(
        RenewType = "None"|"Weekly"|"Monthly",
        ProvisionalConfiguration = list(
          MaxTimeToLiveInMinutes = 123
        ),
        BorrowConfiguration = list(
          AllowEarlyCheckIn = TRUE|FALSE,
          MaxTimeToLiveInMinutes = 123
        )
      ),
      LicenseMetadata = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      CreateTime = "string",
      Version = "string",
      ReceivedMetadata = list(
        ReceivedStatus = "PENDING_WORKFLOW"|"PENDING_ACCEPT"|"REJECTED"|"ACTIVE"|"FAILED_WORKFLOW"|"DELETED"|"DISABLED",
        AllowedOperations = list(
          "CreateGrant"|"CheckoutLicense"|"CheckoutBorrowLicense"|"CheckInLicense"|"ExtendConsumptionLicense"|"ListPurchasedLicenses"|"CreateToken"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists received licenses.
}
\section{Request syntax}{
\preformatted{svc$list_received_licenses(
  LicenseArns = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
