% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_anomaly_detector}
\alias{cloudwatch_put_anomaly_detector}
\title{Creates an anomaly detection model for a CloudWatch metric}
\usage{
cloudwatch_put_anomaly_detector(Namespace, MetricName, Dimensions, Stat,
  Configuration)
}
\arguments{
\item{Namespace}{[required] The namespace of the metric to create the anomaly detection model for.}

\item{MetricName}{[required] The name of the metric to create the anomaly detection model for.}

\item{Dimensions}{The metric dimensions to create the anomaly detection model for.}

\item{Stat}{[required] The statistic to use for the metric and the anomaly detection model.}

\item{Configuration}{The configuration specifies details about how the anomaly detection
model is to be trained, including time ranges to exclude when training
and updating the model. You can specify as many as 10 time ranges.

The configuration can also include the time zone to use for the metric.}
}
\value{
An empty list.
}
\description{
Creates an anomaly detection model for a CloudWatch metric. You can use
the model to display a band of expected normal values when the metric is
graphed.

For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html}{CloudWatch Anomaly Detection}.
}
\section{Request syntax}{
\preformatted{svc$put_anomaly_detector(
  Namespace = "string",
  MetricName = "string",
  Dimensions = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  Stat = "string",
  Configuration = list(
    ExcludedTimeRanges = list(
      list(
        StartTime = as.POSIXct(
          "2015-01-01"
        ),
        EndTime = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    MetricTimezone = "string"
  )
)
}
}

\keyword{internal}
