% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioned_product_properties}
\alias{servicecatalog_update_provisioned_product_properties}
\title{Requests updates to the properties of the specified provisioned product}
\usage{
servicecatalog_update_provisioned_product_properties(AcceptLanguage,
  ProvisionedProductId, ProvisionedProductProperties, IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProvisionedProductId}{[required] The identifier of the provisioned product.}

\item{ProvisionedProductProperties}{[required] A map that contains the provisioned product properties to be updated.

The \code{LAUNCH_ROLE} key accepts role ARNs. This key allows an
administrator to call
\code{\link[=servicecatalog_update_provisioned_product_properties]{update_provisioned_product_properties}}
to update the launch role that is associated with a provisioned product.
This role is used when an end user calls a provisioning operation such
as
\code{\link[=servicecatalog_update_provisioned_product]{update_provisioned_product}},
\code{\link[=servicecatalog_terminate_provisioned_product]{terminate_provisioned_product}},
or
\code{\link[=servicecatalog_execute_provisioned_product_service_action]{execute_provisioned_product_service_action}}.
Only a role ARN is valid. A user ARN is invalid.

The \code{OWNER} key accepts user ARNs and role ARNs. The owner is the user
that has permission to see, update, terminate, and execute service
actions in the provisioned product.

The administrator can change the owner of a provisioned product to
another IAM user within the same account. Both end user owners and
administrators can see ownership history of the provisioned product
using the \code{\link[=servicecatalog_list_record_history]{list_record_history}}
API. The new owner can describe all past records for the provisioned
product using the \code{\link[=servicecatalog_describe_record]{describe_record}}
API. The previous owner can no longer use
\code{\link[=servicecatalog_describe_record]{describe_record}}, but can still see
the product's history from when he was an owner using
\code{\link[=servicecatalog_list_record_history]{list_record_history}}.

If a provisioned product ownership is assigned to an end user, they can
see and perform any action through the API or Service Catalog console
such as update, terminate, and execute service actions. If an end user
provisions a product and the owner is updated to someone else, they will
no longer be able to see or perform any actions through API or the
Service Catalog console on that provisioned product.}

\item{IdempotencyToken}{[required] The idempotency token that uniquely identifies the provisioning product
update request.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProvisionedProductId = "string",
  ProvisionedProductProperties = list(
    "string"
  ),
  RecordId = "string",
  Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED"
)
}
}
\description{
Requests updates to the properties of the specified provisioned product.
}
\section{Request syntax}{
\preformatted{svc$update_provisioned_product_properties(
  AcceptLanguage = "string",
  ProvisionedProductId = "string",
  ProvisionedProductProperties = list(
    "string"
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
