% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_delegated_services_for_account}
\alias{organizations_list_delegated_services_for_account}
\title{List the AWS services for which the specified account is a delegated
administrator}
\usage{
organizations_list_delegated_services_for_account(AccountId, NextToken,
  MaxResults)
}
\arguments{
\item{AccountId}{[required] The account ID number of a delegated administrator account in the
organization.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from.}

\item{MaxResults}{The total number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
that is specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (is not null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that Organizations might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}
}
\value{
A list with the following syntax:\preformatted{list(
  DelegatedServices = list(
    list(
      ServicePrincipal = "string",
      DelegationEnabledDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
List the AWS services for which the specified account is a delegated
administrator.

This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an
AWS service.
}
\section{Request syntax}{
\preformatted{svc$list_delegated_services_for_account(
  AccountId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
