% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_enable_all_features}
\alias{organizations_enable_all_features}
\title{Enables all features in an organization}
\usage{
organizations_enable_all_features()
}
\value{
A list with the following syntax:\preformatted{list(
  Handshake = list(
    Id = "string",
    Arn = "string",
    Parties = list(
      list(
        Id = "string",
        Type = "ACCOUNT"|"ORGANIZATION"|"EMAIL"
      )
    ),
    State = "REQUESTED"|"OPEN"|"CANCELED"|"ACCEPTED"|"DECLINED"|"EXPIRED",
    RequestedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ExpirationTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    Action = "INVITE"|"ENABLE_ALL_FEATURES"|"APPROVE_ALL_FEATURES"|"ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE",
    Resources = list(
      list(
        Value = "string",
        Type = "ACCOUNT"|"ORGANIZATION"|"ORGANIZATION_FEATURE_SET"|"EMAIL"|"MASTER_EMAIL"|"MASTER_NAME"|"NOTES"|"PARENT_HANDSHAKE",
        Resources = list()
      )
    )
  )
)
}
}
\description{
Enables all features in an organization. This enables the use of
organization policies that can restrict the services and actions that
can be called in each account. Until you enable all features, you have
access only to consolidated billing, and you can't use any of the
advanced account administration features that AWS Organizations
supports. For more information, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html}{Enabling All Features in Your Organization}
in the \emph{AWS Organizations User Guide.}

This operation is required only for organizations that were created
explicitly with only the consolidated billing features enabled. Calling
this operation sends a handshake to every invited account in the
organization. The feature set change can be finalized and the additional
features enabled only after all administrators in the invited accounts
approve the change by accepting the handshake.

After you enable all features, you can separately enable or disable
individual policy types in a root using
\code{\link[=organizations_enable_policy_type]{enable_policy_type}} and
\code{\link[=organizations_disable_policy_type]{disable_policy_type}}. To see the
status of policy types in a root, use
\code{\link[=organizations_list_roots]{list_roots}}.

After all invited member accounts accept the handshake, you finalize the
feature set change by accepting the handshake that contains
\code{"Action": "ENABLE_ALL_FEATURES"}. This completes the change.

After you enable all features in your organization, the management
account in the organization can apply policies on all member accounts.
These policies can restrict what users and even administrators in those
accounts can do. The management account can apply policies that prevent
accounts from leaving the organization. Ensure that your account
administrators are aware of this.

This operation can be called only from the organization's management
account.
}
\section{Request syntax}{
\preformatted{svc$enable_all_features()
}
}

\examples{
\dontrun{
# This example shows the administrator asking all the invited accounts in
# the organization to approve enabling all features in the organization.
# AWS Organizations sends an email to the address that is registered with
# every invited member account asking the owner to approve the change by
# accepting the handshake that is sent. After all invited member accounts
# accept the handshake, the organization administrator can finalize the
# change to enable all features, and those with appropriate permissions
# can create policies and apply them to roots, OUs, and accounts:/n/n
svc$enable_all_features()
}

}
\keyword{internal}
