% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_detect_stack_drift}
\alias{cloudformation_detect_stack_drift}
\title{Detects whether a stack's actual configuration differs, or has drifted,
from it's expected configuration, as defined in the stack template and
any values specified as template parameters}
\usage{
cloudformation_detect_stack_drift(StackName, LogicalResourceIds)
}
\arguments{
\item{StackName}{[required] The name of the stack for which you want to detect drift.}

\item{LogicalResourceIds}{The logical names of any resources you want to use as filters.}
}
\value{
A list with the following syntax:\preformatted{list(
  StackDriftDetectionId = "string"
)
}
}
\description{
Detects whether a stack's actual configuration differs, or has
\emph{drifted}, from it's expected configuration, as defined in the stack
template and any values specified as template parameters. For each
resource in the stack that supports drift detection, AWS CloudFormation
compares the actual configuration of the resource with its expected
template configuration. Only resource properties explicitly defined in
the stack template are checked for drift. A stack is considered to have
drifted if one or more of its resources differ from their expected
template configurations. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html}{Detecting Unregulated Configuration Changes to Stacks and Resources}.

Use \code{\link[=cloudformation_detect_stack_drift]{detect_stack_drift}} to detect
drift on all supported resources for a given stack, or
\code{\link[=cloudformation_detect_stack_resource_drift]{detect_stack_resource_drift}}
to detect drift on individual resources.

For a list of stack resources that currently support drift detection,
see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html}{Resources that Support Drift Detection}.

\code{\link[=cloudformation_detect_stack_drift]{detect_stack_drift}} can take up to
several minutes, depending on the number of resources contained within
the stack. Use
\code{\link[=cloudformation_describe_stack_drift_detection_status]{describe_stack_drift_detection_status}}
to monitor the progress of a detect stack drift operation. Once the
drift detection operation has completed, use
\code{\link[=cloudformation_describe_stack_resource_drifts]{describe_stack_resource_drifts}}
to return drift information about the stack and its resources.

When detecting drift on a stack, AWS CloudFormation does not detect
drift on any nested stacks belonging to that stack. Perform
\code{\link[=cloudformation_detect_stack_drift]{detect_stack_drift}} directly on
the nested stack itself.
}
\section{Request syntax}{
\preformatted{svc$detect_stack_drift(
  StackName = "string",
  LogicalResourceIds = list(
    "string"
  )
)
}
}

\keyword{internal}
