% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscalingplans_operations.R
\name{autoscalingplans_describe_scaling_plan_resources}
\alias{autoscalingplans_describe_scaling_plan_resources}
\title{Describes the scalable resources in the specified scaling plan}
\usage{
autoscalingplans_describe_scaling_plan_resources(ScalingPlanName,
  ScalingPlanVersion, MaxResults, NextToken)
}
\arguments{
\item{ScalingPlanName}{[required] The name of the scaling plan.}

\item{ScalingPlanVersion}{[required] The version number of the scaling plan. Currently, the only valid value
is \code{1}.}

\item{MaxResults}{The maximum number of scalable resources to return. The value must be
between 1 and 50. The default value is 50.}

\item{NextToken}{The token for the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  ScalingPlanResources = list(
    list(
      ScalingPlanName = "string",
      ScalingPlanVersion = 123,
      ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
      ResourceId = "string",
      ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
      ScalingPolicies = list(
        list(
          PolicyName = "string",
          PolicyType = "TargetTrackingScaling",
          TargetTrackingConfiguration = list(
            PredefinedScalingMetricSpecification = list(
              PredefinedScalingMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut",
              ResourceLabel = "string"
            ),
            CustomizedScalingMetricSpecification = list(
              MetricName = "string",
              Namespace = "string",
              Dimensions = list(
                list(
                  Name = "string",
                  Value = "string"
                )
              ),
              Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
              Unit = "string"
            ),
            TargetValue = 123.0,
            DisableScaleIn = TRUE|FALSE,
            ScaleOutCooldown = 123,
            ScaleInCooldown = 123,
            EstimatedInstanceWarmup = 123
          )
        )
      ),
      ScalingStatusCode = "Inactive"|"PartiallyActive"|"Active",
      ScalingStatusMessage = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the scalable resources in the specified scaling plan.
}
\section{Request syntax}{
\preformatted{svc$describe_scaling_plan_resources(
  ScalingPlanName = "string",
  ScalingPlanVersion = 123,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
