% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_describe_instance_refreshes}
\alias{autoscaling_describe_instance_refreshes}
\title{Describes one or more instance refreshes}
\usage{
autoscaling_describe_instance_refreshes(AutoScalingGroupName,
  InstanceRefreshIds, NextToken, MaxRecords)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{InstanceRefreshIds}{One or more instance refresh IDs.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxRecords}{The maximum number of items to return with this call. The default value
is \code{50} and the maximum value is \code{100}.}
}
\value{
A list with the following syntax:\preformatted{list(
  InstanceRefreshes = list(
    list(
      InstanceRefreshId = "string",
      AutoScalingGroupName = "string",
      Status = "Pending"|"InProgress"|"Successful"|"Failed"|"Cancelling"|"Cancelled",
      StatusReason = "string",
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      PercentageComplete = 123,
      InstancesToUpdate = 123
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes one or more instance refreshes.

You can determine the status of a request by looking at the \code{Status}
parameter. The following are the possible statuses:
\itemize{
\item \code{Pending} - The request was created, but the operation has not
started.
\item \code{InProgress} - The operation is in progress.
\item \code{Successful} - The operation completed successfully.
\item \code{Failed} - The operation failed to complete. You can troubleshoot
using the status reason and the scaling activities.
\item \code{Cancelling} - An ongoing operation is being cancelled. Cancellation
does not roll back any replacements that have already been
completed, but it prevents new replacements from being started.
\item \code{Cancelled} - The operation is cancelled.
}

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html}{Replacing Auto Scaling Instances Based on an Instance Refresh}.
}
\section{Request syntax}{
\preformatted{svc$describe_instance_refreshes(
  AutoScalingGroupName = "string",
  InstanceRefreshIds = list(
    "string"
  ),
  NextToken = "string",
  MaxRecords = 123
)
}
}

\examples{
\dontrun{
# This example describes the instance refreshes for the specified Auto
# Scaling group.
svc$describe_instance_refreshes(
  AutoScalingGroupName = "my-auto-scaling-group"
)
}

}
\keyword{internal}
