% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_token}
\alias{licensemanager_create_token}
\title{Creates a long-lived token}
\usage{
licensemanager_create_token(LicenseArn, RoleArns, ExpirationInDays,
  TokenProperties, ClientToken)
}
\arguments{
\item{LicenseArn}{[required] Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud
claim of the JWT token.}

\item{RoleArns}{Amazon Resource Name (ARN) of the IAM roles to embed in the token.
License Manager does not check whether the roles are in use.}

\item{ExpirationInDays}{Token expiration, in days, counted from token creation. The default is
365 days.}

\item{TokenProperties}{Data specified by the caller to be included in the JWT token. The data
is mapped to the amr claim of the JWT token.}

\item{ClientToken}{[required] Idempotency token, valid for 10 minutes.}
}
\description{
Creates a long-lived token.

A refresh token is a JWT token used to get an access token. With an
access token, you can call AssumeRoleWithWebIdentity to get role
credentials that you can use to call License Manager to manage the
specified license.
}
\section{Request syntax}{
\preformatted{svc$create_token(
  LicenseArn = "string",
  RoleArns = list(
    "string"
  ),
  ExpirationInDays = 123,
  TokenProperties = list(
    "string"
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
