% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_config_rule}
\alias{configservice_put_config_rule}
\title{Adds or updates an AWS Config rule for evaluating whether your AWS
resources comply with your desired configurations}
\usage{
configservice_put_config_rule(ConfigRule, Tags)
}
\arguments{
\item{ConfigRule}{[required] The rule that you want to add to your account.}

\item{Tags}{An array of tag object.}
}
\description{
Adds or updates an AWS Config rule for evaluating whether your AWS
resources comply with your desired configurations.

You can use this action for custom AWS Config rules and AWS managed
Config rules. A custom AWS Config rule is a rule that you develop and
maintain. An AWS managed Config rule is a customizable, predefined rule
that AWS Config provides.

If you are adding a new custom AWS Config rule, you must first create
the AWS Lambda function that the rule invokes to evaluate your
resources. When you use the \code{PutConfigRule} action to add the rule to
AWS Config, you must specify the Amazon Resource Name (ARN) that AWS
Lambda assigns to the function. Specify the ARN for the
\code{SourceIdentifier} key. This key is part of the \code{Source} object, which
is part of the \code{ConfigRule} object.

If you are adding an AWS managed Config rule, specify the rule's
identifier for the \code{SourceIdentifier} key. To reference AWS managed
Config rule identifiers, see \href{https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html}{About AWS Managed Config Rules}.

For any new rule that you add, specify the \code{ConfigRuleName} in the
\code{ConfigRule} object. Do not specify the \code{ConfigRuleArn} or the
\code{ConfigRuleId}. These values are generated by AWS Config for new rules.

If you are updating a rule that you added previously, you can specify
the rule by \code{ConfigRuleName}, \code{ConfigRuleId}, or \code{ConfigRuleArn} in the
\code{ConfigRule} data type that you use in this request.

The maximum number of rules that AWS Config supports is 150.

For information about requesting a rule limit increase, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config}{AWS Config Limits}
in the \emph{AWS General Reference Guide}.

For more information about developing and using AWS Config rules, see
\href{https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html}{Evaluating AWS Resource Configurations with AWS Config}
in the \emph{AWS Config Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_config_rule(
  ConfigRule = list(
    ConfigRuleName = "string",
    ConfigRuleArn = "string",
    ConfigRuleId = "string",
    Description = "string",
    Scope = list(
      ComplianceResourceTypes = list(
        "string"
      ),
      TagKey = "string",
      TagValue = "string",
      ComplianceResourceId = "string"
    ),
    Source = list(
      Owner = "CUSTOM_LAMBDA"|"AWS",
      SourceIdentifier = "string",
      SourceDetails = list(
        list(
          EventSource = "aws.config",
          MessageType = "ConfigurationItemChangeNotification"|"ConfigurationSnapshotDeliveryCompleted"|"ScheduledNotification"|"OversizedConfigurationItemChangeNotification",
          MaximumExecutionFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours"
        )
      )
    ),
    InputParameters = "string",
    MaximumExecutionFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours",
    ConfigRuleState = "ACTIVE"|"DELETING"|"DELETING_RESULTS"|"EVALUATING",
    CreatedBy = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
