% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_list_public_keys}
\alias{cloudtrail_list_public_keys}
\title{Returns all public keys whose private keys were used to sign the digest
files within the specified time range}
\usage{
cloudtrail_list_public_keys(StartTime, EndTime, NextToken)
}
\arguments{
\item{StartTime}{Optionally specifies, in UTC, the start of the time range to look up
public keys for CloudTrail digest files. If not specified, the current
time is used, and the current public key is returned.}

\item{EndTime}{Optionally specifies, in UTC, the end of the time range to look up
public keys for CloudTrail digest files. If not specified, the current
time is used.}

\item{NextToken}{Reserved for future use.}
}
\description{
Returns all public keys whose private keys were used to sign the digest
files within the specified time range. The public key is needed to
validate digest files that were signed with its corresponding private
key.

CloudTrail uses different private/public key pairs per region. Each
digest file is signed with a private key unique to its region.
Therefore, when you validate a digest file from a particular region, you
must look in the same region for its corresponding public key.
}
\section{Request syntax}{
\preformatted{svc$list_public_keys(
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
