# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Augmented AI Runtime
#'
#' @description
#' Amazon Augmented AI (Amazon A2I) adds the benefit of human judgment to
#' any machine learning application. When an AI application can't evaluate
#' data with a high degree of confidence, human reviewers can take over.
#' This human review is called a human review workflow. To create and start
#' a human review workflow, you need three resources: a *worker task
#' template*, a *flow definition*, and a *human loop*.
#' 
#' For information about these resources and prerequisites for using Amazon
#' A2I, see [Get Started with Amazon Augmented
#' AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-getting-started.html)
#' in the Amazon SageMaker Developer Guide.
#' 
#' This API reference includes information about API actions and data types
#' that you can use to interact with Amazon A2I programmatically. Use this
#' guide to:
#' 
#' -   Start a human loop with the
#'     [`start_human_loop`][augmentedairuntime_start_human_loop] operation
#'     when using Amazon A2I with a *custom task type*. To learn more about
#'     the difference between custom and built-in task types, see [Use Task
#'     Types](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-task-types-general.html)
#'     . To learn how to start a human loop using this API, see [Create and
#'     Start a Human Loop for a Custom Task
#'     Type](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-start-human-loop.html#a2i-instructions-starthumanloop)
#'     in the Amazon SageMaker Developer Guide.
#' 
#' -   Manage your human loops. You can list all human loops that you have
#'     created, describe individual human loops, and stop and delete human
#'     loops. To learn more, see [Monitor and Manage Your Human
#'     Loop](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-monitor-humanloop-results.html)
#'     in the Amazon SageMaker Developer Guide.
#' 
#' Amazon A2I integrates APIs from various AWS services to create and start
#' human review workflows for those services. To learn how Amazon A2I uses
#' these APIs, see [Use APIs in Amazon
#' A2I](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-api-references.html)
#' in the Amazon SageMaker Developer Guide.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- augmentedairuntime(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- augmentedairuntime()
#' svc$delete_human_loop(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=augmentedairuntime_delete_human_loop]{delete_human_loop} \tab Deletes the specified human loop for a flow definition\cr
#'  \link[=augmentedairuntime_describe_human_loop]{describe_human_loop} \tab Returns information about the specified human loop\cr
#'  \link[=augmentedairuntime_list_human_loops]{list_human_loops} \tab Returns information about human loops, given the specified parameters\cr
#'  \link[=augmentedairuntime_start_human_loop]{start_human_loop} \tab Starts a human loop, provided that at least one activation condition is met\cr
#'  \link[=augmentedairuntime_stop_human_loop]{stop_human_loop} \tab Stops the specified human loop
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname augmentedairuntime
#' @export
augmentedairuntime <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .augmentedairuntime$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.augmentedairuntime <- list()

.augmentedairuntime$operations <- list()

.augmentedairuntime$metadata <- list(
  service_name = "augmentedairuntime",
  endpoints = list("*" = list(endpoint = "a2i-runtime.sagemaker.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "a2i-runtime.sagemaker.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "a2i-runtime.sagemaker.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "a2i-runtime.sagemaker.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "a2i-runtime.sagemaker.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "a2i-runtime.sagemaker.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "SageMaker A2I Runtime",
  api_version = "2019-11-07",
  signing_name = "sagemaker",
  json_version = "",
  target_prefix = ""
)

.augmentedairuntime$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.augmentedairuntime$metadata, handlers, config, op)
}
