% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_start_lending_analysis}
\alias{textract_start_lending_analysis}
\title{Starts the classification and analysis of an input document}
\usage{
textract_start_lending_analysis(
  DocumentLocation,
  ClientRequestToken = NULL,
  JobTag = NULL,
  NotificationChannel = NULL,
  OutputConfig = NULL,
  KMSKeyId = NULL
)
}
\arguments{
\item{DocumentLocation}{[required]}

\item{ClientRequestToken}{The idempotent token that you use to identify the start request. If you
use the same token with multiple
\code{\link[=textract_start_lending_analysis]{start_lending_analysis}} requests,
the same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the
same job from being accidentally started more than once. For more
information, see \href{https://docs.aws.amazon.com/textract/latest/dg/}{Calling Amazon Textract Asynchronous Operations}.}

\item{JobTag}{An identifier that you specify to be included in the completion
notification published to the Amazon SNS topic. For example, you can use
\code{JobTag} to identify the type of document that the completion
notification corresponds to (such as a tax form or a receipt).}

\item{NotificationChannel}{}

\item{OutputConfig}{}

\item{KMSKeyId}{The KMS key used to encrypt the inference results. This can be in either
Key ID or Key Alias format. When a KMS key is provided, the KMS key will
be used for server-side encryption of the objects in the customer
bucket. When this parameter is not enabled, the result will be encrypted
server side, using SSE-S3.}
}
\description{
Starts the classification and analysis of an input document. \code{\link[=textract_start_lending_analysis]{start_lending_analysis}} initiates the classification and analysis of a packet of lending documents. \code{\link[=textract_start_lending_analysis]{start_lending_analysis}} operates on a document file located in an Amazon S3 bucket.

See \url{https://www.paws-r-sdk.com/docs/textract_start_lending_analysis/} for full documentation.
}
\keyword{internal}
