% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_hub_content_versions}
\alias{sagemaker_list_hub_content_versions}
\title{List hub content versions}
\usage{
sagemaker_list_hub_content_versions(
  HubName,
  HubContentType,
  HubContentName,
  MinVersion = NULL,
  MaxSchemaVersion = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{HubName}{[required] The name of the hub to list the content versions of.}

\item{HubContentType}{[required] The type of hub content to list versions of.}

\item{HubContentName}{[required] The name of the hub content.}

\item{MinVersion}{The lower bound of the hub content versions to list.}

\item{MaxSchemaVersion}{The upper bound of the hub content schema version.}

\item{CreationTimeBefore}{Only list hub content versions that were created before the time
specified.}

\item{CreationTimeAfter}{Only list hub content versions that were created after the time
specified.}

\item{SortBy}{Sort hub content versions by either name or creation time.}

\item{SortOrder}{Sort hub content versions by ascending or descending order.}

\item{MaxResults}{The maximum number of hub content versions to list.}

\item{NextToken}{If the response to a previous
\code{\link[=sagemaker_list_hub_content_versions]{list_hub_content_versions}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of hub content versions, use the token in the next request.}
}
\description{
List hub content versions.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_hub_content_versions/} for full documentation.
}
\keyword{internal}
