% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_trial}
\alias{sagemaker_create_trial}
\title{Creates an SageMaker trial}
\usage{
sagemaker_create_trial(
  TrialName,
  DisplayName = NULL,
  ExperimentName,
  MetadataProperties = NULL,
  Tags = NULL
)
}
\arguments{
\item{TrialName}{[required] The name of the trial. The name must be unique in your Amazon Web
Services account and is not case-sensitive.}

\item{DisplayName}{The name of the trial as displayed. The name doesn't need to be unique.
If \code{DisplayName} isn't specified, \code{TrialName} is displayed.}

\item{ExperimentName}{[required] The name of the experiment to associate the trial with.}

\item{MetadataProperties}{}

\item{Tags}{A list of tags to associate with the trial. You can use
\code{\link[=sagemaker_search]{search}} API to search on the tags.}
}
\description{
Creates an SageMaker \emph{trial}. A trial is a set of steps called \emph{trial components} that produce a machine learning model. A trial is part of a single SageMaker \emph{experiment}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_trial/} for full documentation.
}
\keyword{internal}
