% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_training_job}
\alias{sagemaker_update_training_job}
\title{Update a model training job to request a new Debugger profiling
configuration or to change warm pool retention length}
\usage{
sagemaker_update_training_job(
  TrainingJobName,
  ProfilerConfig = NULL,
  ProfilerRuleConfigurations = NULL,
  ResourceConfig = NULL,
  RemoteDebugConfig = NULL
)
}
\arguments{
\item{TrainingJobName}{[required] The name of a training job to update the Debugger profiling
configuration.}

\item{ProfilerConfig}{Configuration information for Amazon SageMaker Debugger system
monitoring, framework profiling, and storage paths.}

\item{ProfilerRuleConfigurations}{Configuration information for Amazon SageMaker Debugger rules for
profiling system and framework metrics.}

\item{ResourceConfig}{The training job \code{ResourceConfig} to update warm pool retention length.}

\item{RemoteDebugConfig}{Configuration for remote debugging while the training job is running.
You can update the remote debugging configuration when the
\code{SecondaryStatus} of the job is \code{Downloading} or \code{Training}.To learn
more about the remote debugging functionality of SageMaker, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html}{Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging}.}
}
\description{
Update a model training job to request a new Debugger profiling configuration or to change warm pool retention length.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_training_job/} for full documentation.
}
\keyword{internal}
