% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_describe_voices}
\alias{polly_describe_voices}
\title{Returns the list of voices that are available for use when requesting
speech synthesis}
\usage{
polly_describe_voices(
  Engine = NULL,
  LanguageCode = NULL,
  IncludeAdditionalLanguageCodes = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Engine}{Specifies the engine (\code{standard} or \code{neural}) used by Amazon Polly when
processing input text for speech synthesis.}

\item{LanguageCode}{The language identification tag (ISO 639 code for the language name-ISO
3166 country code) for filtering the list of voices returned. If you
don't specify this optional parameter, all available voices are
returned.}

\item{IncludeAdditionalLanguageCodes}{Boolean value indicating whether to return any bilingual voices that use
the specified language as an additional language. For instance, if you
request all languages that use US English (es-US), and there is an
Italian voice that speaks both Italian (it-IT) and US English, that
voice will be included if you specify \code{yes} but not if you specify \code{no}.}

\item{NextToken}{An opaque pagination token returned from the previous
\code{\link[=polly_describe_voices]{describe_voices}} operation. If present, this
indicates where to continue the listing.}
}
\description{
Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice name.

See \url{https://www.paws-r-sdk.com/docs/polly_describe_voices/} for full documentation.
}
\keyword{internal}
