% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_endpoint}
\alias{sagemaker_create_endpoint}
\title{Creates an endpoint using the endpoint configuration specified in the
request}
\usage{
sagemaker_create_endpoint(
  EndpointName,
  EndpointConfigName,
  DeploymentConfig = NULL,
  Tags = NULL
)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint.The name must be unique within an Amazon Web
Services Region in your Amazon Web Services account. The name is
case-insensitive in \code{\link[=sagemaker_create_endpoint]{create_endpoint}}, but
the case is preserved and must be matched in .}

\item{EndpointConfigName}{[required] The name of an endpoint configuration. For more information, see
\code{\link[=sagemaker_create_endpoint_config]{create_endpoint_config}}.}

\item{DeploymentConfig}{}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your Amazon
Web Services resources in different ways, for example, by purpose,
owner, or environment. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging Amazon Web Services Resources}.}
}
\description{
Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the \code{\link[=sagemaker_create_endpoint_config]{create_endpoint_config}} API.

See \url{https://paws-r.github.io/docs/sagemaker/create_endpoint.html} for full documentation.
}
\keyword{internal}
