% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_app}
\alias{sagemaker_create_app}
\title{Creates a running app for the specified UserProfile}
\usage{
sagemaker_create_app(
  DomainId,
  UserProfileName,
  AppType,
  AppName,
  Tags = NULL,
  ResourceSpec = NULL
)
}
\arguments{
\item{DomainId}{[required] The domain ID.}

\item{UserProfileName}{[required] The user profile name.}

\item{AppType}{[required] The type of app. Supported apps are \code{JupyterServer} and \code{KernelGateway}.
\code{TensorBoard} is not supported.}

\item{AppName}{[required] The name of the app.}

\item{Tags}{Each tag consists of a key and an optional value. Tag keys must be
unique per resource.}

\item{ResourceSpec}{The instance type and the Amazon Resource Name (ARN) of the SageMaker
image created on the instance.

The value of \code{InstanceType} passed as part of the \code{ResourceSpec} in the
\code{\link[=sagemaker_create_app]{create_app}} call overrides the value passed as
part of the \code{ResourceSpec} configured for the user profile or the
domain. If \code{InstanceType} is not specified in any of those three
\code{ResourceSpec} values for a \code{KernelGateway} app, the
\code{\link[=sagemaker_create_app]{create_app}} call fails with a request
validation error.}
}
\description{
Creates a running app for the specified UserProfile. Supported apps are \code{JupyterServer} and \code{KernelGateway}. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.

See \url{https://paws-r.github.io/docs/sagemaker/create_app.html} for full documentation.
}
\keyword{internal}
