% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_create_batch_import_job}
\alias{frauddetector_create_batch_import_job}
\title{Creates a batch import job}
\usage{
frauddetector_create_batch_import_job(
  jobId,
  inputPath,
  outputPath,
  eventTypeName,
  iamRoleArn,
  tags = NULL
)
}
\arguments{
\item{jobId}{[required] The ID of the batch import job. The ID cannot be of a past job, unless
the job exists in \code{CREATE_FAILED} state.}

\item{inputPath}{[required] The URI that points to the Amazon S3 location of your data file.}

\item{outputPath}{[required] The URI that points to the Amazon S3 location for storing your results.}

\item{eventTypeName}{[required] The name of the event type.}

\item{iamRoleArn}{[required] The ARN of the IAM role created for Amazon S3 bucket that holds your
data file. The IAM role must have read and write permissions to both
input and output S3 buckets.}

\item{tags}{A collection of key-value pairs associated with this request.}
}
\description{
Creates a batch import job.

See \url{https://paws-r.github.io/docs/frauddetector/create_batch_import_job.html} for full documentation.
}
\keyword{internal}
