% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_update_endpoint}
\alias{comprehend_update_endpoint}
\title{Updates information about the specified endpoint}
\usage{
comprehend_update_endpoint(
  EndpointArn,
  DesiredModelArn = NULL,
  DesiredInferenceUnits = NULL,
  DesiredDataAccessRoleArn = NULL
)
}
\arguments{
\item{EndpointArn}{[required] The Amazon Resource Number (ARN) of the endpoint being updated.}

\item{DesiredModelArn}{The ARN of the new model to use when updating an existing endpoint.}

\item{DesiredInferenceUnits}{The desired number of inference units to be used by the model using this
endpoint. Each inference unit represents of a throughput of 100
characters per second.}

\item{DesiredDataAccessRoleArn}{Data access role ARN to use in case the new model is encrypted with a
customer CMK.}
}
\description{
Updates information about the specified endpoint. For information about endpoints, see \href{https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html}{Managing endpoints}.

See \url{https://paws-r.github.io/docs/comprehend/update_endpoint.html} for full documentation.
}
\keyword{internal}
