% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_put_resource_policy}
\alias{comprehend_put_resource_policy}
\title{Attaches a resource-based policy to a custom model}
\usage{
comprehend_put_resource_policy(
  ResourceArn,
  ResourcePolicy,
  PolicyRevisionId = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the custom model to attach the policy
to.}

\item{ResourcePolicy}{[required] The JSON resource-based policy to attach to your custom model. Provide
your JSON as a UTF-8 encoded string without line breaks. To provide
valid JSON for your policy, enclose the attribute names and values in
double quotes. If the JSON body is also enclosed in double quotes, then
you must escape the double quotes that are inside the policy:

\verb{"\{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]\}"}

To avoid escaping quotes, you can use single quotes to enclose the
policy and double quotes to enclose the JSON names and values:

\code{'{"attribute": "value", "attribute": ["value"]}'}}

\item{PolicyRevisionId}{The revision ID that Amazon Comprehend assigned to the policy that you
are updating. If you are creating a new policy that has no prior
version, don't use this parameter. Amazon Comprehend creates the
revision ID for you.}
}
\description{
Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another AWS account to import the custom model, which replicates it in Amazon Comprehend in their account.

See \url{https://paws-r.github.io/docs/comprehend/put_resource_policy.html} for full documentation.
}
\keyword{internal}
