% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_start_medical_transcription_job}
\alias{transcribeservice_start_medical_transcription_job}
\title{Start a batch job to transcribe medical speech to text}
\usage{
transcribeservice_start_medical_transcription_job(
  MedicalTranscriptionJobName, LanguageCode, MediaSampleRateHertz,
  MediaFormat, Media, OutputBucketName, OutputEncryptionKMSKeyId,
  Settings, Specialty, Type)
}
\arguments{
\item{MedicalTranscriptionJobName}{[required] The name of the medical transcription job. You can\'t use the strings
\".\" or \"..\" by themselves as the job name. The name must also be
unique within an AWS account. If you try to create a medical
transcription job with the same name as a previous medical transcription
job you will receive a \code{ConflictException} error.}

\item{LanguageCode}{[required] The language code for the language spoken in the input media file. US
English (en-US) is the valid value for medical transcription jobs. Any
other value you enter for language code results in a
\code{BadRequestException} error.}

\item{MediaSampleRateHertz}{The sample rate, in Hertz, of the audio track in the input media file.

If you do not specify the media sample rate, Amazon Transcribe Medical
determines the sample rate. If you specify the sample rate, it must
match the rate detected by Amazon Transcribe Medical. In most cases, you
should leave the \code{MediaSampleRateHertz} field blank and let Amazon
Transcribe Medical determine the sample rate.}

\item{MediaFormat}{The audio format of the input media file.}

\item{Media}{[required]}

\item{OutputBucketName}{[required] The Amazon S3 location where the transcription is stored.

You must set \code{OutputBucketName} for Amazon Transcribe Medical to store
the transcription results. Your transcript appears in the S3 location
you specify. When you call the GetMedicalTranscriptionJob, the operation
returns this location in the \code{TranscriptFileUri} field. The S3 bucket
must have permissions that allow Amazon Transcribe Medical to put files
in the bucket. For more information, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user}{Permissions Required for IAM User Roles}.

You can specify an AWS Key Management Service (KMS) key to encrypt the
output of your transcription using the \code{OutputEncryptionKMSKeyId}
parameter. If you don\'t specify a KMS key, Amazon Transcribe Medical
uses the default Amazon S3 key for server-side encryption of transcripts
that are placed in your S3 bucket.}

\item{OutputEncryptionKMSKeyId}{The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS)
key used to encrypt the output of the transcription job. The user
calling the StartMedicalTranscriptionJob operation must have permission
to use the specified KMS key.

You use either of the following to identify a KMS key in the current
account:
\itemize{
\item KMS Key ID: \"1234abcd-12ab-34cd-56ef-1234567890ab\"
\item KMS Key Alias: \"alias/ExampleAlias\"
}

You can use either of the following to identify a KMS key in the current
account or another account:
\itemize{
\item Amazon Resource Name (ARN) of a KMS key in the current account or
another account: \"arn:aws:kms:region:account
ID:key/1234abcd-12ab-34cd-56ef-1234567890ab\"
\item ARN of a KMS Key Alias: \"arn:aws:kms:region:account
ID:alias/ExampleAlias\"
}

If you don\'t specify an encryption key, the output of the medical
transcription job is encrypted with the default Amazon S3 key (SSE-S3).

If you specify a KMS key to encrypt your output, you must also specify
an output location in the \code{OutputBucketName} parameter.}

\item{Settings}{Optional settings for the medical transcription job.}

\item{Specialty}{[required] The medical specialty of any clinician speaking in the input media.}

\item{Type}{[required] The type of speech in the input audio. \code{CONVERSATION} refers to
conversations between two or more speakers, e.g., a conversations
between doctors and patients. \code{DICTATION} refers to single-speaker
dictated speech, e.g., for clinical notes.}
}
\description{
Start a batch job to transcribe medical speech to text.
}
\section{Request syntax}{
\preformatted{svc$start_medical_transcription_job(
  MedicalTranscriptionJobName = "string",
  LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA"|"ru-RU"|"zh-CN"|"nl-NL"|"id-ID"|"ta-IN"|"fa-IR"|"en-IE"|"en-AB"|"en-WL"|"pt-PT"|"te-IN"|"tr-TR"|"de-CH"|"he-IL"|"ms-MY"|"ja-JP"|"ar-AE",
  MediaSampleRateHertz = 123,
  MediaFormat = "mp3"|"mp4"|"wav"|"flac",
  Media = list(
    MediaFileUri = "string"
  ),
  OutputBucketName = "string",
  OutputEncryptionKMSKeyId = "string",
  Settings = list(
    ShowSpeakerLabels = TRUE|FALSE,
    MaxSpeakerLabels = 123,
    ChannelIdentification = TRUE|FALSE,
    ShowAlternatives = TRUE|FALSE,
    MaxAlternatives = 123,
    VocabularyName = "string"
  ),
  Specialty = "PRIMARYCARE",
  Type = "CONVERSATION"|"DICTATION"
)
}
}

\keyword{internal}
