% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_stop_notebook_instance}
\alias{sagemaker_stop_notebook_instance}
\title{Terminates the ML compute instance}
\usage{
sagemaker_stop_notebook_instance(NotebookInstanceName)
}
\arguments{
\item{NotebookInstanceName}{[required] The name of the notebook instance to terminate.}
}
\description{
Terminates the ML compute instance. Before terminating the instance,
Amazon SageMaker disconnects the ML storage volume from it. Amazon
SageMaker preserves the ML storage volume. Amazon SageMaker stops
charging you for the ML compute instance when you call
\code{StopNotebookInstance}.
}
\details{
To access data on the ML storage volume for a notebook instance that has
been terminated, call the \code{StartNotebookInstance} API.
\code{StartNotebookInstance} launches another ML compute instance, configures
it, and attaches the preserved ML storage volume so you can continue
your work.
}
\section{Request syntax}{
\preformatted{svc$stop_notebook_instance(
  NotebookInstanceName = "string"
)
}
}

\keyword{internal}
