% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_workforce}
\alias{sagemaker_describe_workforce}
\title{Lists private workforce information, including workforce name, Amazon
Resource Name (ARN), and, if applicable, allowed IP address ranges
(CIDRs)}
\usage{
sagemaker_describe_workforce(WorkforceName)
}
\arguments{
\item{WorkforceName}{[required] The name of the private workforce whose access you want to restrict.
\code{WorkforceName} is automatically set to \code{default} when a workforce is
created and cannot be modified.}
}
\description{
Lists private workforce information, including workforce name, Amazon
Resource Name (ARN), and, if applicable, allowed IP address ranges
(\href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html}{CIDRs}).
Allowable IP address ranges are the IP addresses that workers can use to
access tasks.
}
\details{
This operation applies only to private workforces.
}
\section{Request syntax}{
\preformatted{svc$describe_workforce(
  WorkforceName = "string"
)
}
}

\keyword{internal}
